const express = require('express');

const downloadApp = express.Router();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const Download = require(`${libs}/models/download`);

const passport = require('passport');

const request = require(`request`);

const config = require(`${libs}/config`);

downloadApp.get('/', passport.authenticate('bearer', { session: false }), (req, res, next) => {
    request.get(config.cdn.url + '/api/v1/file', async (err, response, body) => {
        let cdn = JSON.parse(body);
        const downloads = await Download.findAll({ where: { user_id: req.user.id } }).catch(function (err) {
            if (err) {
                log.error(err);
                return next(err);
            }
        });
        if (!downloads) {
            res.statusCode = 404;
            return res.json({ msg: 'Nenhum download encontrado' });
        } else {
            downloads.forEach((dl) => {
                for (let i = 0; i < cdn.length; ++i) {
                    if (cdn[i].query == dl.query) {
                        dl.status = cdn[i].expired ? 'Expirado' : 'Enviado';
                        dl.size = cdn[i].size;
                        dl.expired = cdn[i].expired;
                        dl.updatedAt = cdn[i].lastAccess;
                        dl.link = config.cdn.download + '/' + cdn[i]._id;

                        dl.save((err) => {
                            if (err) log.error(err);
                        });
                        return;
                    }
                }
            });
        }
        res.json(downloads);
    });
});

module.exports = downloadApp;
