var stream = require('stream');
const libs = `${process.cwd()}/libs`;
const File = require(`${libs}/models/file`);

exports.uploadFile = async (_file) => {
	let file = await File.create({
        id: 0,
		type: _file.mimetype,
		name: _file.originalname,
		data: _file.buffer
	}).catch(err => {
		console.log(err);
		res.json({msg: 'Error', detail: err});
	});
	return file.id;
}

exports.listAllFiles = (req, res) => {
	File.findAll({attributes: ['id', 'name']}).then(files => {
	  res.json(files);
	}).catch(err => {
		console.log(err);
		res.json({msg: 'Error', detail: err});
	});
}

exports.downloadFile = (req, res) => {
	File.findByPk(req.params.id).then(file => {
		var fileContents = Buffer.from(file.data, "base64");
		var readStream = new stream.PassThrough();
		readStream.end(fileContents);
		
		res.set('Content-disposition', 'attachment; filename=' + file.name);
		res.set('Content-Type', file.type);

		readStream.pipe(res);
	}).catch(err => {
		console.log(err);
		res.json({msg: 'Error', detail: err});
	});
}
