/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const pibpercapitaApp = express.Router();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const id2str = require(`${libs}/middlewares/id2str`);

const addMissing = require(`${libs}/middlewares/addMissing`);

const config = require(`${libs}/config`);

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

let rqf = new ReqQueryFields();

pibpercapitaApp.use(cache('15 day'));

pibpercapitaApp.get('/year_range', (req, res, next) => {
    req.sql.from('ibge_pib')
    .field('MIN(ibge_pib.ano_censo)', 'start_year')
    .field('MAX(ibge_pib.ano_censo)', 'end_year')
    .where('ibge_pib.ano_censo > 2013');
    next();
}, query, response('range'));

pibpercapitaApp.get('/years', (req, res, next) => {
    req.sql.from('ibge_pib').
    field('DISTINCT ibge_pib.ano_censo', 'year')
    .where('ibge_pib.ano_censo > 2013');
    next();
}, query, response('years'));

pibpercapitaApp.get('/source', (req, res, next) => {
    req.sql.from('fonte')
    .field('fonte', 'source')
    .where('tabela = \'ibge_pib\'');
    next();
}, query, response('source'));

pibpercapitaApp.get('/income_level', (req, res, next) => {
    req.result = [
        {id: 1, name: "1º quintil – 20% menores"},
        {id: 2, name: "2º quintil"},
        {id: 3, name: "3º quintil"},
        {id: 4, name: "4º quintil"},
        {id: 5, name: "5º quintil – 20% maiores"},
    ];
    next();
}, response('income_level'));

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'city',
    table: 'municipio',
    tableField: ['nome', 'id'],
    resultField: ['city_name', 'city_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'municipio_id',
        table: 'ibge_pib'
    },
    join: {
        primary: 'id',
        foreign: 'municipio_id',
        foreignTable: 'ibge_pib'
    }
}).addValue({
    name: 'state',
    table: 'estado',
    tableField: ['nome', 'id'],
    resultField: ['state_name', 'state_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'estado_id',
        table: '@'
    },
    join: {
        primary: 'id',
        foreign: 'estado_id',
        foreignTable: '@'
    }
}).addValue({
    name: 'region',
    table: 'regiao',
    tableField: ['nome', 'id'],
    resultField: ['region_name', 'region_id'],
    where: {
      relation: '=',
      type: 'integer',
      field: 'regiao_id',
      table: 'ibge_pib'
    },
    join: {
        primary: 'id',
        foreign: 'regiao_id',
        foreignTable: 'ibge_pib'
    }
}).addValue({
    name: 'min_year',
    table: '@',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '>=',
        type: 'integer',
        field: 'ano_censo'
    }
}).addValue({
    name: 'max_year',
    table: '@',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '<=',
        type: 'integer',
        field: 'ano_censo'
    }
}).addValue({
    name: 'income_level',
    table: 'ibge_pib',
    tableField: 'nivel_renda_per_capita',
    resultField: 'income_level_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'nivel_renda_per_capita'
    }
}).addValue({
    name: 'income_level_brasil',
    table: 'ibge_pib',
    tableField: 'nivel_renda_brasil',
    resultField: 'income_level_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'nivel_renda_brasil'
    }
}).addValue({
    name: 'income_level_uf',
    table: 'ibge_pib',
    tableField: 'nivel_renda_uf',
    resultField: 'income_level_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'nivel_renda_uf'
    }
});;

pibpercapitaApp.get('/', rqf.parse(), (req, res, next) => {
    if ('income_level' in req.dims) {   // Retorna os quintis
        delete req.dims.income_level

        req.sql.from('pib_quintis')
        .field('pib_quintis.valor', 'total')
        .field('pib_quintis.tipo', 'income_level_id')
        .field('pib_quintis.ano_censo', 'year')
        .group('pib_quintis.ano_censo')
        .group('pib_quintis.valor')
        .group('pib_quintis.tipo')
        .order('pib_quintis.tipo')

        if (!('state' in req.filter)) {
            req.sql.where('pib_quintis.estado_id = 0')
        } 
        if ('city' in req.filter) {
            req.sql.join('ibge_pib', null, 'ibge_pib.nivel_renda_brasil=pib_quintis.tipo AND ibge_pib.ano_censo=pib_quintis.ano_censo')
        }
    }

    else if (("city" in req.dims) || ("city" in req.filter)) {
      req.sql.from('ibge_pib')
      .field('ibge_pib.pib_per_capita', 'total')
      .field('ibge_pib.ano_censo', 'year')
      .group('ibge_pib.ano_censo')
      .group('ibge_pib.pib_per_capita')
      .order('ibge_pib.ano_censo')
  } else  {
      req.sql.from('ibge_pib')
      .field('SUM(ibge_pib.pib)/SUM(ibge_pib.populacao)', 'total')
      .field('ibge_pib.ano_censo', 'year')
      .group('ibge_pib.ano_censo')
      .order('ibge_pib.ano_censo')
   }
   next();
}, rqf.build(), query, (req, res, next) => {
     req.result.forEach((i) => {
        let value = parseFloat(i.total);
        let isnum = /^\d+$/.test(value);
        if (isnum == true) {
            value = value.toFixed(2)
        }
        // console.log(i.total);

        let res = value.toString().split(".");
        //rounding decimal.
        let decimal = Math.round(res[1].toString().substring(0,2) + (".") + res[1].toString().substring(2,3));
        //case 0 after comma
        if (res[1].toString().substring(0,1) == 0) {
            i.total = parseFloat(res[0] + "." + "0" + decimal);
        } else {
            i.total = parseFloat(res[0] + "." +  decimal);
        }
        // console.log(i.total);
     });
     next();
 }, id2str.transform(false), response("pibpercapita"));


module.exports = pibpercapitaApp;
