const express = require('express');

const portalMecApp = express.Router();

const libs = `${process.cwd()}/libs`;

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const id2str = require(`${libs}/middlewares/id2str`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const addMissing = require(`${libs}/middlewares/addMissing`);

const config = require(`${libs}/config`);

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

let rqf = new ReqQueryFields();

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'day',
    table: 'docente',
    tableField: 'nasc_dia',
    resultField: 'born_day_id',
    where: {
        relation: '=',
        type: 'integer',
        table: 'docente',
        field: 'nasc_dia'
    }
}).addValue({
    name: 'month',
    table: 'docente',
    tableField: 'nasc_mes_id',
    resultField: 'born_month',
    where: {
        relation: '=',
        type: 'integer',
        table: 'docente',
        field: 'nasc_mes'
    }
}).addValue({
    name: 'year',
    table: 'docente',
    tableField: 'nasc_ano_id',
    resultField: 'born_year',
    where: {
        relation: '=',
        type: 'integer',
        table: 'docente',
        field: 'nasc_ano'
    }
}).addValue({
    name: 'teacher',
    table: 'docente',
    tableField: 'id',
    resultField: 'teacher_id',
    where: {
        relation: '=',
        type: 'integer',
        table: 'docente',
        field: 'id'
    }
}).addValue({
    name: 'min_year',
    table: 'docente',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '>=',
        type: 'integer',
        table: 'docente',
        field: 'ano_censo'
    }
}).addValue({
    name: 'max_year',
    table: 'docente',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '<=',
        type: 'integer',
        table: 'docente',
        field: 'ano_censo'
    }
});

portalMecApp.get('/', rqf.parse(), (req, res, next) => {

    req.sql.field('docente.id_docente')
    .field('docente.ano_censo', 'year')
    .field('docente.cod_quimica', 'Química')
    .field('docente.cod_fisica', 'Física')
    .field('docente.cod_matematica', 'Matemática')
    .field('docente.cod_biologia', 'Biologia')
    .field('docente.cod_ciencias', 'Ciências')
    .field('docente.cod_literat_port', 'Língua/ Literatura Portuguesa')
    .field('docente.cod_literat_ing', 'Língua/ Literatura estrangeira - Inglês')
    .field('docente.cod_literat_esp', 'Língua/ Literatura estrangeira - Espanhol')
    .field('docente.cod_literat_frances', 'Língua/ Literatura estrangeira - Francês')
    .field('docente.literat_outra', 'Língua/ Literatura estrangeira - Outra')
    .field('docente.cod_literat_indigena', 'Língua/ Literatura estrangeira - Língua Indígena')
    .field('docente.cod_artes', 'Artes (Educação Artística, Teatro, Dança, Música, Artes Plásticas e outras)')
    .field('docente.cod_ed_fisica', 'Educação Física')
    .field('docente.cod_hist', 'História')
    .field('docente.cod_geo', 'Geografia')
    .field('docente.cod_filos', 'Filosofia')
    .field('docente.cod_ensino_religioso', 'Ensino Religioso')
    .field('docente.cod_estudos_sociais', 'Estudos Sociais')
    .field('docente.cod_sociologia', 'Sociologia')
    .field('docente.cod_inf_comp', 'Informática/ Computação')
    .field('docente.cod_profissionalizante', 'Disciplinas profissionalizantes')
    .field('docente.cod_disc_atendimento_especiais', 'Disciplinas voltadas ao atendimento às necessidades educacionais específicas dos alunos que são público alvo da educação especial e às práticas educacionais inclusivas')
    .field('docente.cod_disc_diversidade_socio_cult', 'Disciplinas voltadas à diversidade sociocultural (Disciplinas pedagógicas)')
    .field('docente.cod_libras', 'Libras')
    .field('docente.cod_disciplina_pedag', 'Disciplinas pedagógicas')
    .field('docente.cod_outras_disciplina', 'Outras disciplinas')
    .from('docente')
    next();

}, rqf.build(), query, response('portalMec'));

module.exports = portalMecApp;
