/*
Copyright (C) 2024 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const uniLocalOfferAggregateApp = express.Router();

const libs = `${process.cwd()}/libs`;

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const config = require(`${libs}/config`); 

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

let rqf = new ReqQueryFields();

uniLocalOfferAggregateApp.use(cache('15 day'));

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'min_year',
    table: 'curso_superior_agregado',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '>=',
        type: 'integer',
        field: 'ano_censo'
    }
}).addValue({
    name: 'max_year',
    table: 'curso_superior_agregado',
    tableField: '',
    resultField: 'year',
    where: {
        relation: '<=',
        type: 'integer',
        field: 'ano_censo'
    }
}).addValue({
    name: 'region',
    table: 'curso_superior_agregado',
    tableField: 'cod_reg',
    resultField: 'region_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_reg'
    }
}).addValue({
    name: 'state',
    table: 'estado',
    tableField: ['id', 'nome'],
    resultField: ['state_id', 'state_nome'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id',
    },
    join: {
        primary: 'id',
        foreign: 'cod_uf',
        foreignTable: 'curso_superior_agregado'
    }
}).addValue({
    name: 'city',
    table: 'municipio',
    tableField: ['id', 'nome'],
    resultField: ['city_id', 'city_name'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id',
        table: 'municipio'
    },
    join: {
        primary: 'id',
        foreign: 'cod_mun',
        foreignTable: 'curso_superior_agregado'
    }
});

uniLocalOfferAggregateApp.get('/', rqf.parse(), rqf.build(), (req, res, next) => {
    req.sql.from('curso_superior_agregado')
    .field('DISTINCT curso_superior_agregado.cod_ies', 'id')
    .field('ies_ens_superior.nome_ies', 'name')
    .field('curso_superior_agregado.cod_mun', 'city_id')
    .field('curso_superior_agregado.cod_uf', 'state_id')
    .field('curso_superior_agregado.cod_reg', 'region_id')
    .join('ies_ens_superior', null, 'curso_superior_agregado.cod_ies = ies_ens_superior.cod_ies and curso_superior_agregado.ano_censo = ies_ens_superior.ano_censo')
    .order('curso_superior_agregado.cod_ies')
    next();
}, query, response('uni_offer_aggregate'));

module.exports = uniLocalOfferAggregateApp;