/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const universityApp = express.Router();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const id2str = require(`${libs}/middlewares/id2str`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const request = require(`request`);

const config = require(`${libs}/config`);

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

const addMissing = require(`${libs}/middlewares/addMissing`);

let rqf = new ReqQueryFields();

let rqfCount = new ReqQueryFields();

universityApp.use(cache('15 day'));

universityApp.get('/upper_adm_dependency', (req, res, next) => {
    req.result = [];
    for(let i = 1; i <= 7; ++i) {
        req.result.push({
            id: i,
            name: id2str.upperAdmDependency(i)
        });
    };
    next();
}, response('upper_adm_dependency'));

universityApp.get('/years', (req, res, next) => {
    req.sql.from('ies_ens_superior')
    .field('DISTINCT ies_ens_superior.ano_censo', 'year')
    next();
}, query, response('years'));

universityApp.get('/year_range', (req, res, next) => {
    req.sql.from('ies_ens_superior')
    .field('MIN(ies_ens_superior.ano_censo)', 'start_year')
    .field('MAX(ies_ens_superior.ano_censo)', 'end_year');
    next();
}, query, response('range'));

universityApp.get('/academic_organization', (req, res, next) => {
    req.result = [];
    for(let i = 1; i <= 5; ++i) {
        req.result.push({
            id: i,
            name: id2str.academicOrganization(i)
        });
    };
    next();
}, response('academic_organization'));

universityApp.get('/capital', (req, res, next) => {
    req.result = [];
    for(let i = 0; i <= 1; ++i) {
        req.result.push({
            id: i,
            name: id2str.booleanVariable(i)
        });
    };
    next();
}, response('capital'));

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addValue({
    name: 'id',
    table: 'ies_ens_superior',
    tableField: 'cod_ies',
    resultField: 'id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_ies'
    }
}).addValue({
    name: 'city',
    table: 'municipio',
    tableField: ['nome', 'id'],
    resultField: ['city_name', 'city_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_municipio_ies',
        table: 'ies_ens_superior'
    },
    join: {
        primary: 'id',
        foreign: 'cod_municipio_ies',
        foreignTable: 'ies_ens_superior'
    }
}).addValue({
    name: 'state',
    table: 'estado',
    tableField: ['nome', 'id'],
    resultField: ['state_name', 'state_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_uf_ies',
        table: 'ies_ens_superior'
    },
    join: {
        primary: 'id',
        foreign: 'cod_uf_ies',
        foreignTable: 'ies_ens_superior'
    }
}).addValue({
    name: 'region',
    table: 'regiao',
    tableField: ['nome', 'id'],
    resultField: ['region_name', 'region_id'],
    where: {
        relation: 'LIKE',
        type: 'string',
        field: 'id'
    },
    join: {
        primary: 'nome',
        foreign: 'nome_regiao_ies',
        foreignTable: 'ies_ens_superior'
    }
}).addValue({
    name: 'year',
    table: 'ies_ens_superior',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '=',
        type: 'integer',
        field: 'ano_censo',
        table: 'ies_ens_superior'
    }
}).addField({
    name: 'search',
    field: true,
    where: true
}).addValueToField({
    name: 'city_name',
    table: 'municipio',
    tableField: 'nome',
    resultField: 'city_name',
    dontGroup: true,
    where: {
        relation: 'LIKE',
        type: 'string',
        field: 'nome'
    },
    join: {
      primary: 'id',
      foreign: 'cod_municipio_ies',
      foreignTable: 'ies_ens_superior'
    }
}, 'search')
.addValueToField({
    name: 'state_name',
    table: 'estado',
    tableField: 'nome',
    resultField: 'state_name',
    dontGroup: true,
    where: {
        relation: 'LIKE',
        type: 'string',
        field: 'sigla'
    },
    join: {
      primary: 'id',
      foreign: 'cod_uf_ies',
      foreignTable: 'ies_ens_superior'
    }
}, 'search');


rqfCount.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'city',
    table: 'municipio',
    tableField: ['nome', 'id'],
    resultField: ['city_name', 'city_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_municipio_ies',
        table: 'ies_ens_superior'
    },
    join: {
        primary: 'id',
        foreign: 'cod_municipio_ies',
        foreignTable: 'ies_ens_superior'
    }
}).addValue({
    name: 'region',
    table: 'regiao',
    tableField: ['nome', 'id'],
    resultField: ['region_name', 'region_id'],
    where: {
        relation: 'LIKE',
        type: 'string',
        field: 'id'
    },
    join: {
        primary: 'nome',
        foreign: 'nome_regiao_ies',
        foreignTable: 'ies_ens_superior'
    }

}).addValue({
    name: 'min_year',
    table: '@',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '>=',
        type: 'integer',
        table: '@',
        field: 'ano_censo'
    }
}).addValue({
    name: 'max_year',
    table: '@',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '<=',
        type: 'integer',
        table: '@',
        field: 'ano_censo'
    }
}).addValue({
    name: 'state',
    table: 'estado',
    tableField: ['nome', 'id'],
    resultField: ['state_name', 'state_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_uf_ies',
        table: '@'
    },
    join: {
        primary: 'id',
        foreign: 'cod_uf_ies',
        foreignTable: '@'
    }
}).addValue({
    name: 'upper_adm_dependency',
    table: 'ies_ens_superior',
    tableField: 'par_categoria_administrativa',
    resultField: 'upper_adm_dependency_id',
    where: {
        relation: '=',
        type: 'integer',
        table: 'ies_ens_superior',
        field: 'cod_categoria_administrativa'
    }
}).addValue({
    name: 'academic_organization',
    table: 'ies_ens_superior',
    tableField: 'cod_organizacao_academica',
    resultField: 'academic_organization_id',
    where: {
        relation: '=',
        type: 'integer',
        table: 'ies_ens_superior',
        field: 'cod_organizacao_academica'
    }
}).addValue({
    name: 'capital',
    table: 'ies_ens_superior',
    tableField: 'tfd_capital_ies',
    resultField: 'capital_id',
    where: {
        relation: '=',
        type: 'integer',
        table: 'ies_ens_superior',
        field: 'capital_ies'
    }
});

universityApp.get('/', rqf.parse(),  rqf.build(), (req, res, next) => {
    req.sql.from('ies_ens_superior')
        .field('ies_ens_superior.cod_ies', 'id')
        .field('ies_ens_superior.ano_censo', 'year')
        .field('ies_ens_superior.nome_ies', 'name')
        .field('ies_ens_superior.cod_uf_ies', 'state_id')
        .field('ies_ens_superior.cod_municipio_ies', 'city_id')
        .field('ies_ens_superior.cod_uf_ies/10', 'region_id');
    next();

}, query, response('university'));

universityApp.get('/count', rqfCount.parse(), (req, res, next) => {
    req.sql.field('COUNT(*)', 'total')
    .field("'Brasil'", 'name')
    .field('ies_ens_superior.ano_censo', 'year')
    .from('ies_ens_superior')
    .group('ies_ens_superior.ano_censo')
    .order('ies_ens_superior.ano_censo')

    next();
}, rqfCount.build(), query, addMissing(rqfCount), id2str.transform(), response('university'));

module.exports = universityApp;
