/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const api = express();

const libs = `${process.cwd()}/libs`;

const config = require(`${libs}/config`);

const classes = require('./class');

const enrollment = require('./enrollment');

const state = require('./state');

const region = require('./region');

const city = require('./city');

const school = require('./school');

const simulation = require('./simulation');

const user = require('./user');

const classroom = require('./classroom');

const teacher = require('./teacher');

const idhme = require('./idhme');

const pibpercapita = require('./pibpercapita')

const population = require('./population')

const rateSchool = require('./rateSchool')

const glossEnrollmentRatio = require('./glossEnrollmentRatio')

const liquidEnrollmentRatio = require('./liquidEnrollmentRatio')

const idhm = require('./idhm');

const idhmr = require('./idhmr');

const idhml = require('./idhml');

const oauth2 = require(`${libs}/middlewares/oauth2`);

const verifyToken = require(`${libs}/routes_v2/verifyToken`);

const resetToken = require(`${libs}/routes_v2/resetToken`);

const educationYears = require(`${libs}/routes_v2/educationYears`);

const downloads = require(`${libs}/routes_v2/downloads`);

const infrastructure = require(`${libs}/routes_v2/infrastructure`);

const schoolInfrastructure = require(`${libs}/routes_v2/schoolInfrastructure`);

const distributionFactor = require(`${libs}/routes_v2/distributionFactor`);

const siope = require(`${libs}/routes_v2/siope`);

const verifyTeacher = require(`${libs}/routes_v2/portalMec`);

const outOfSchool = require(`${libs}/routes_v2/outOfSchool`);

const classroomCount = require(`${libs}/routes_v2/classroomCount`);

const transport = require(`./transport`);

const auxiliar = require(`${libs}/routes_v2/auxiliar`);

const dailyChargeAmount = require(`${libs}/routes_v2/dailyChargeAmount`);

const cub = require(`${libs}/routes_v2/cub`);

const classCount = require(`${libs}/routes_v2/classCount`);

const portalMecInep = require(`${libs}/routes_v2/portalMecInep`);

const enrollmentProjection = require(`${libs}/routes_v2/enrollmentProjection`);

const employees = require(`${libs}/routes_v2/employees`);

const financial = require(`${libs}/routes_v2/financial`);

const universityEnrollment = require(`${libs}/routes_v2/universityEnrollment`);

const courseCount = require(`${libs}/routes_v2/courseCount`);

const university = require(`${libs}/routes_v2/university`);

const universityTeacher = require(`${libs}/routes_v2/universityTeacher`);

const educationalBudget = require(`${libs}/routes_v2/educationalBudget`);

const schoolLocation = require(`${libs}/routes_v2/schoolLocation`);

const studentsAee = require(`${libs}/routes_v2/studentsAee`);

const mesoregion = require(`${libs}/routes_v2/mesoregion`);

const microregion = require(`${libs}/routes_v2/microregion`);

const location = require(`${libs}/routes_v2/location`);

const disciplines = require(`${libs}/routes_v2/disciplines`);

const universityLocalOffer = require(`${libs}/routes_v2/universityLocalOffer`);

const message = require(`${libs}/routes_v2/message`);

const courseStudents = require(`${libs}/routes_v2/courseStudents`);

const simcaqFirstReport = require(`${libs}/routes_v2/simcaqFirstReport`);

const simcaqEnrollmentDiagnosis = require(`${libs}/routes_v2/simcaqEnrollmentDiagnosis`);

const simcaqSecondReport = require(`${libs}/routes_v2/simcaqSecondReport`);

const simcaqDivisionOfResponsibility = require(`${libs}/routes_v2/simcaqDivisionOfResponsibility`);

const simcaqClassroomSize = require(`${libs}/routes_v2/simcaqClassroomSize`);

const simcaqWorkload = require(`${libs}/routes_v2/simcaqWorkload`);

const simcaqNumberOfEmployees = require(`${libs}/routes_v2/simcaqNumberOfEmployees`);

const simcaqNewClasses = require(`${libs}/routes_v2/simcaqNewClasses`);

const simcaqResult = require(`${libs}/routes_v2/simcaqResult`);

const simcaqNumberOfTeachers = require(`${libs}/routes_v2/simcaqNumberOfTeachers`);

const simcaqEnrollmentProjection = require(`${libs}/routes_v2/simcaqEnrollmentProjection`);

const simcaqAggregatedEnrollment = require(`${libs}/routes_v2/simcaqAggregatedEnrollment`);

const simcaqTeacherCityPlan = require(`${libs}/routes_v2/simcaqTeacherCityPlan`);

const simcaqSchoolInfrastructure = require(`${libs}/routes_v2/simcaqSchoolInfrastructure`);

api.get('/', (req, res) => {
    res.json({ msg: 'SimCAQ API v2 is running' });
});

// mount API routes_v2
api.use('/user', user);
api.use('/simulation', simulation);
api.use('/class', classes);
api.use('/enrollment', enrollment);
api.use('/state', state);
api.use('/region', region);
api.use('/city', city);
api.use('/school', school);
api.use('/classroom', classroom);
api.use('/teacher', teacher);
api.use('/idhmr', idhmr);
api.use('/idhm', idhm);
api.use('/idhme', idhme);
api.use('/pibpercapita', pibpercapita);
api.use('/population', population);
api.use('/rate_school', rateSchool);
api.use('/gloss_enrollment_ratio', glossEnrollmentRatio);
api.use('/liquid_enrollment_ratio', liquidEnrollmentRatio);
api.use('/idhml', idhml);
api.use('/auth/token', oauth2.token);
api.use('/verify', verifyToken);
api.use('/reset', resetToken);
api.use('/education_years', educationYears);
api.use('/downloads', downloads);
api.use('/infrastructure', infrastructure);
api.use('/school_infrastructure', schoolInfrastructure);
api.use('/distribution_factor', distributionFactor);
api.use('/siope', siope);
api.use('/out_of_school', outOfSchool);
api.use('/classroom_count', classroomCount);
api.use('/daily_charge_amount', dailyChargeAmount);
api.use('/transport', transport);
api.use('/cub', cub);
api.use('/auxiliar', auxiliar);
api.use('/verify_teacher', verifyTeacher);
api.use('/class_count', classCount);
api.use('/portal_mec_inep', portalMecInep);
api.use('/enrollment_projection', enrollmentProjection);
api.use('/employees', employees);
api.use('/financial', financial);
api.use('/university_enrollment', universityEnrollment);
api.use('/university', university);
api.use('/university_teacher', universityTeacher);
api.use('/course_count', courseCount);
api.use('/school_location', schoolLocation);
api.use('/students_aee', studentsAee);
api.use('/mesoregion', mesoregion);
api.use('/microregion', microregion);
api.use('/location', location);
api.use('/disciplines', disciplines);
api.use('/universityLocalOffer', universityLocalOffer);
api.use('/message', message);
api.use('/course_students', courseStudents);
api.use('/simcaq_first_report', simcaqFirstReport);
api.use('/simcaq_enrollment_diagnosis', simcaqEnrollmentDiagnosis);
api.use('/simcaq_second_report', simcaqSecondReport);
api.use('/simcaq_division_of_responsibility', simcaqDivisionOfResponsibility);
api.use('/simcaq_classroom_size', simcaqClassroomSize);
api.use('/simcaq_workload', simcaqWorkload);
api.use('/simcaq_number_of_employees', simcaqNumberOfEmployees);
api.use('/simcaq_new_classes', simcaqNewClasses);
api.use('/simcaq_result', simcaqResult);
api.use('/simcaq_number_of_teachers', simcaqNumberOfTeachers);
api.use('/simcaq_enrollment_projection', simcaqEnrollmentProjection);
api.use('/simcaq_aggregated_enrollment', simcaqAggregatedEnrollment);
api.use('/simcaq_teacher_city_plan', simcaqTeacherCityPlan);
api.use('/simcaq_school_infrastructure', simcaqSchoolInfrastructure);

module.exports = api;
