/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const financialApp = express.Router();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const id2str = require(`${libs}/middlewares/id2str`);

const addMissing = require(`${libs}/middlewares/addMissing`);

const config = require(`${libs}/config`);

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

let rqf = new ReqQueryFields();

financialApp.get('/year_range', (req, res, next) => {
    req.sql.from('indicadores_financeiros')
    .field('MIN(indicadores_financeiros.ano_censo)', 'start_year')
    .field('MAX(indicadores_financeiros.ano_censo)', 'end_year');
    next();
}, query, response('range'));

financialApp.get('/years', (req, res, next) => {
    req.sql.from('indicadores_financeiros')
    .field('DISTINCT indicadores_financeiros.ano_censo', 'year');
    next();
}, query, response('years'));

financialApp.get('/sphere_adm', (req, res, next) => {
    req.result = [
        {id: 1, name: "1"},
        {id: 2, name: "2"}
    ]
    next();
}, response('sphere_adm'));

financialApp.get('/financial_data', (req, res, next) => {
    req.sql.from('indicadores_financeiros')
    .field('DISTINCT indicadores_financeiros.dados_financeiros', 'financial_data');
    next();
}, query, response('financial_data'));

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'state',
    table: 'estado',
    tableField: ['sigla', 'id'],
    resultField: ['sigla_uf', 'cod_uf'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'estado_id',
        table: 'indicadores_financeiros'
    },
    join: {
        primary: 'id',
        foreign: 'estado_id',
        foreignTable: 'indicadores_financeiros'
    }
}).addValue({
    name: 'min_year',
    table: 'indicadores_financeiros',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '>=',
        type: 'integer',
        table: 'indicadores_financeiros',
        field: 'ano_censo'
    }
}).addValue({
    name: 'max_year',
    table: 'indicadores_financeiros',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '<=',
        type: 'integer',
        table: 'indicadores_financeiros',
        field: 'ano_censo'
    }
}).addValue({
    name: 'sphere_adm',
    table: 'indicadores_financeiros',
    tableField: 'esfera_adm',
    resultField: 'sphere_adm_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'esfera_adm'
    }
}).addValue({
    name: 'city',
    table: 'indicadores_financeiros',
    tableField: 'municipio_id',
    resultField: 'city_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'municipio_id'
    }
}).addValue({
    name: 'financial_data',
    table: 'indicadores_financeiros',
    tableField: 'dados_financeiros',
    resultField: 'financial_data_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'dados_financeiros'
    }
});

financialApp.get('/', rqf.parse(), rqf.build(), (req, res, next) => {
		if ("state" in req.filter) {
	    req.sql.from('indicadores_financeiros')
	    .field('indicadores_financeiros.estado_id', 'state_id')
	    .field('indicadores_financeiros.ano_censo', 'year')
	    .field('estado.sigla', 'state_abbreviation')
	    .field('indicadores_financeiros.valor', 'valor')
	    .field('indicadores_financeiros.esfera_adm', 'sphere_adm_id')
	    .field('indicadores_financeiros.dados_financeiros', 'financial_data_id')
	    .group('indicadores_financeiros.ano_censo')
	    .group('indicadores_financeiros.estado_id')
	    .group('estado.sigla')
	    .group('indicadores_financeiros.valor')
	    .group('indicadores_financeiros.dados_financeiros')
	    .group('indicadores_financeiros.esfera_adm')
		} else {
	    req.sql.from('indicadores_financeiros')
	    .field('indicadores_financeiros.estado_id', 'state_id')
	    .field('indicadores_financeiros.ano_censo', 'year')
	    .field('estado.sigla', 'state_abbreviation')
	    .field('indicadores_financeiros.valor', 'valor')
	    .field('indicadores_financeiros.esfera_adm', 'sphere_adm_id')
	    .field('indicadores_financeiros.dados_financeiros', 'financial_data_id')
	    .join('estado', null, 'indicadores_financeiros.estado_id=estado.id')
	    .group('indicadores_financeiros.ano_censo')
	    .group('indicadores_financeiros.estado_id')
	    .group('estado.sigla')
	    .group('indicadores_financeiros.valor')
	    .group('indicadores_financeiros.dados_financeiros')
	    .group('indicadores_financeiros.esfera_adm')
		}
    next();
}, query, id2str.transform(), response('financial'));

module.exports = financialApp;
