/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const simcaqAggregatedEnrollmentApp = express.Router();

const libs = `${process.cwd()}/libs`;

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const reqBody = require(`${libs}/middlewares/reqBody`);

const config = require(`${libs}/config`); 

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

let rqf = new ReqQueryFields();

const id2str = require(`${libs}/middlewares/id2str`);

simcaqAggregatedEnrollmentApp.use(cache('15 day'));

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'year',
    table: 'simcaq_matricula_agregada',
    tableField: 'ano_censo',
    where: {
        relation: '=',
        type: 'integer',
        field: 'ano_censo'
    }
}).addValue({
    name: 'city',
    table: 'municipio',
    tableField: ['nome', 'id'],
    resultField: ['city_name', 'city_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'municipio_id',
        foreignTable: 'simcaq_matricula_agregada'
    }
}, 'dims').addValue({
    name: 'state',
    table: 'estado',
    tableField: ['nome', 'id'],
    resultField: ['state_name', 'state_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'estado_id',
        foreignTable: 'simcaq_matricula_agregada'
    }
}, 'dims').addValue({
    name: 'region',
    table: 'regiao',
    tableField: ['nome', 'id'],
    resultField: ['region_name', 'region_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'regiao_id',
        foreignTable: 'simcaq_matricula_agregada'
    }
}, 'dims').addValue({
    name: 'school',
    table: 'escola_agregada',
    tableField: 'id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'escola_id',
        foreignTable: 'simcaq_matricula_agregada'
    }
}, 'dims').addValue({
    name: 'locale',
    table: 'simcaq_matricula_agregada',
    tableField: 'localizacao_id',
    resultField: 'locale_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'localizacao_id'
    }
}).addValue({
    name: 'adm_dependency_id',
    table: 'simcaq_matricula_agregada',
    tableField: 'dependencia_adm_id',
    resultField: 'adm_dependency_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'dependencia_adm_id'
    }
}).addValue({
    name: 'adm_dependency_detailed_id',
    table: 'simcaq_matricula_agregada',
    tableField: 'dependencia_adm_priv',
    resultField: 'adm_dependency_detailed_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'dependencia_adm_priv'
    }
}).addValue({
    name: 'diff_location_id',
    table: 'simcaq_matricula_agregada',
    tableField: 'localizacao_diferenciada_par',
    resultField: 'diff_location_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'localizacao_diferenciada_par'
    }
}).addValue({
    name: 'school_building',
    table: 'simcaq_matricula_agregada',
    tableField: 'local_func_predio_escolar',
    where: {
        relation: '=',
        type: 'boolean',
        field: 'local_func_predio_escolar'
    }
}).addValue({
    name: 'rural_location_id',
    table: 'simcaq_matricula_agregada',
    tableField: 'localidade_area_rural',
    where: {
        relation: '=',
        type: 'integer',
        field: 'localidade_area_rural'
    }
}).addValue({
    name: 'school_year_id',
    table: 'simcaq_matricula_agregada',
    tableField: 'serie_ano_id',
    resultField: 'school_year_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'serie_ano_id'
    }
}).addValue({
    name: 'education_level_short_id',
    table: 'simcaq_matricula_agregada',
    tableField: 'etapa_resumida',
    resultField: 'education_level_short_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'etapa_resumida'
    }
});

simcaqAggregatedEnrollmentApp.get('/', rqf.parse(), rqf.build(), (req, res, next) => {
    req.sql.from('simcaq_matricula_agregada')
        .field('SUM(simcaq_matricula_agregada.num_matriculas)', 'num_enrollments')
        .field('simcaq_matricula_agregada.ano_censo', 'year')
        .group('simcaq_matricula_agregada.ano_censo');
    next();
}, query, id2str.transform(), response('aggregatedEnrollment'));

module.exports = simcaqAggregatedEnrollmentApp;
