/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const simcaqNumberOfTeachersApp = express.Router();

const libs = `${process.cwd()}/libs`;

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const reqBody = require(`${libs}/middlewares/reqBody`);

const config = require(`${libs}/config`); 

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

let rqf = new ReqQueryFields();

const id2str = require(`${libs}/middlewares/id2str`);

simcaqNumberOfTeachersApp.use(cache('15 day'));

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'year',
    table: 'simcaq_num_professores',
    tableField: 'ano_censo',
    where: {
        relation: '=',
        type: 'integer',
        field: 'ano_censo'
    }
}).addValue({
    name: 'local_id',
    table: 'simcaq_num_professores',
    tableField: 'local_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'local_id'
    }
}).addValue({
    name: 'level_id',
    table: 'simcaq_num_professores',
    tableField: 'nivel',
    where: {
        relation: '=',
        type: 'integer',
        field: 'nivel'
    }
}).addValue({
    name: 'type_id',
    table: 'simcaq_num_professores',
    tableField: 'tipo',
    where: {
        relation: '=',
        type: 'integer',
        field: 'tipo'
    }
});

simcaqNumberOfTeachersApp.get('/', rqf.parse(), rqf.build(), (req, res, next) => {
    req.sql.from('simcaq_num_professores')
        .field('total', 'number_of_teachers')
        .field('simcaq_num_professores.ano_censo', 'year')
        .field('simcaq_num_professores.nivel', 'level_id')
        .field('simcaq_num_professores.tipo', 'type_id')
        .field('simcaq_num_professores.local_id', 'local_id');
    next();
}, query, id2str.transform(), response('simcaqNumberOfTeachers'));

module.exports = simcaqNumberOfTeachersApp;
