/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const simcaqSchoolInfrastructureApp = express.Router();

const libs = `${process.cwd()}/libs`;

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const reqBody = require(`${libs}/middlewares/reqBody`);

const config = require(`${libs}/config`); 

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

let rqf = new ReqQueryFields();

const id2str = require(`${libs}/middlewares/id2str`);

simcaqSchoolInfrastructureApp.use(cache('15 day'));

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'year',
    table: 'simcaq_school_infrastructure',
    tableField: 'ano_censo',
    where: {
        relation: '=',
        type: 'integer',
        field: 'ano_censo'
    }
}).addValue({
    name: 'scholar_dependency',
    table: 'simcaq_school_infrastructure',
    tableField: 'scholar_dependency_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'scholar_dependency_id'
    }
});

simcaqSchoolInfrastructureApp.get('/', rqf.parse(), rqf.build(), (req, res, next) => {
    req.sql.from('simcaq_school_infrastructure')
        .field('simcaq_school_infrastructure.ano_censo', 'year')
        .field('simcaq_school_infrastructure.scholar_dependency_id', 'scholar_dependency_id')
        .field('SUM(simcaq_school_infrastructure.total_schools)', 'total_schools')
        .field('SUM(total_no_dependency)', 'total_schools_without_dependency')
        .field('SUM(total_with_dependency)', 'total_schools_with_dependency')
        .group('simcaq_school_infrastructure.ano_censo')
        .group('simcaq_school_infrastructure.scholar_dependency_id');
    next();
}, query, id2str.transform(), response('simcaqSchoolInfrastructure'));

module.exports = simcaqSchoolInfrastructureApp;
