/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const teacherEnrollmentApp = express.Router();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const id2str = require(`${libs}/middlewares/id2str`);

const addMissing = require(`${libs}/middlewares/addMissing`);

const config = require(`${libs}/config`);

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

let rqf = new ReqQueryFields();

teacherEnrollmentApp.get('/years', (req, res, next) => {
    req.sql.from('docente_ens_superior')
    .field('DISTINCT docente_ens_superior.ano_censo', 'year');
    next();
}, query, response('years'));

teacherEnrollmentApp.get('/year_range', (req, res, next) => {
    req.sql.from('docente_ens_superior')
    .field('MIN(docente_ens_superior.ano_censo)', 'start_year')
    .field('MAX(docente_ens_superior.ano_censo)', 'end_year');
    next();
}, query, response('range'));

teacherEnrollmentApp.get('/academic_organization', (req, res, next) => {
    req.result = [];
    for(let i = 1; i <= 5; ++i) {
        req.result.push({
            id: i,
            name: id2str.academicOrganization(i)
        });
    };
    next();
}, response('academic_organization'));

teacherEnrollmentApp.get('/upper_adm_dependency', (req, res, next) => {
    req.result = [];
    for(let i = 1; i <= 7; ++i) {
        req.result.push({
            id: i,
            name: id2str.upperAdmDependency(i)
        });
    };
    next();
}, response('upper_adm_dependency'));

teacherEnrollmentApp.get('/teacher_situation', (req, res, next) => {
    req.result = [];
    for(let i = 1; i <= 6; ++i) {
        req.result.push({
            id: i,
            name: id2str.teacherSituation(i)
        });
    };
    next();
}, response('teacher_situation'));

teacherEnrollmentApp.get('/work_regime', (req, res, next) => {
    req.result = [{
        id: "null",
        name: id2str.workRegime("null")
    }];
    for(let i = 1; i <= 4; ++i) {
        req.result.push({
            id: i,
            name: id2str.workRegime(i)
        });
    };
    next();
}, response('work_regime'));

teacherEnrollmentApp.get('/substitute', (req, res, next) => {
    req.result = [{
        id: "null",
        name: id2str.booleanVariable("null")
    }];
    for(let i = 0; i <= 1; ++i) {
        req.result.push({
            id: i,
            name: id2str.booleanVariable(i)
        });
    };
    next();
}, response('substitute'));

teacherEnrollmentApp.get('/visitor', (req, res, next) => {
    req.result = [{
        id: "null",
        name: id2str.booleanVariable("null")
    }];
    for(let i = 0; i <= 1; ++i) {
        req.result.push({
            id: i,
            name: id2str.booleanVariable(i)
        });
    };
    next();
}, response('visitor'));

teacherEnrollmentApp.get('/ead_teacher', (req, res, next) => {
    req.result = [{
        id: "null",
        name: id2str.booleanVariable("null")
    }];
    for(let i = 0; i <= 1; ++i) {
        req.result.push({
            id: i,
            name: id2str.booleanVariable(i)
        });
    };
    next();
}, response('ead_teacher'));

teacherEnrollmentApp.get('/graduation_presential', (req, res, next) => {
    req.result = [{
        id: "null",
        name: id2str.booleanVariable("null")
    }];
    for(let i = 0; i <= 1; ++i) {
        req.result.push({
            id: i,
            name: id2str.booleanVariable(i)
        });
    };
    next();
}, response('graduation_presential'));

teacherEnrollmentApp.get('/postgraduate_ead_teacher', (req, res, next) => {
    req.result = [{
        id: "null",
        name: id2str.booleanVariable("null")
    }];
    for(let i = 0; i <= 1; ++i) {
        req.result.push({
            id: i,
            name: id2str.booleanVariable(i)
        });
    };
    next();
}, response('postgraduate_ead_teacher'));

teacherEnrollmentApp.get('/postgraduate_presential_teacher', (req, res, next) => {
    req.result = [{
        id: "null",
        name: id2str.booleanVariable("null")
    }];
    for(let i = 0; i <= 1; ++i) {
        req.result.push({
            id: i,
            name: id2str.booleanVariable(i)
        });
    };
    next();
}, response('postgraduate_presential_teacher'));

teacherEnrollmentApp.get('/deficiency', (req, res, next) => {
    req.result = [{
        id: 9,
        name: id2str.studentDeficiency(9)
    }];
    for(let i = 0; i <= 1; ++i) {
        req.result.push({
            id: i,
            name: id2str.studentDeficiency(i)
        });
    };
    next();
}, response('deficiency'));

teacherEnrollmentApp.get('/ethnic_group_teacher_ies', (req, res, next) => {
    req.result = [{
        id: 9,
        name: id2str.ethnicGroupTeacherIES(9)
    }];
    for(let i = 0; i <= 5; ++i) {
        req.result.push({
            id: i,
            name: id2str.ethnicGroupTeacherIES(i)
        });
    };
    next();
}, response('ethnic_group_teacher_ies'));

teacherEnrollmentApp.get('/teacher_schooling', (req, res, next) => {
    req.result = [];
    for(let i = 1; i <= 5; ++i) {
        req.result.push({
            id: i,
            name: id2str.teacherSchooling(i)
        });
    };
    next();
}, response('teacher_schooling'));

teacherEnrollmentApp.get('/gender_ies', (req, res, next) => {
    req.result = [];
    for(let i = 1; i <= 2; ++i) {
        req.result.push({
            id: i,
            name: id2str.genderIES(i)
        });
    };
    next();
}, response('gender_ies'));


rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'min_year',
    table: '@',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '>=',
        type: 'integer',
        table: '@',
        field: 'ano_censo'
    }
}).addValue({
    name: 'max_year',
    table: '@',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '<=',
        type: 'integer',
        table: '@',
        field: 'ano_censo'
    }
}).addValue({
    name: 'state',
    table: 'estado',
    tableField: ['nome', 'id'],
    resultField: ['state_name', 'state_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_uf_ies',
        table: '@'
    },
    join: {
        primary: 'id',
        foreign: 'cod_uf_ies',
        foreignTable: '@'
    }
}).addValue({
    name: 'city',
    table: 'municipio',
    tableField: ['nome', 'id'],
    resultField: ['city_name', 'city_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_municipio_ies',
        table: '@'
    },
    join: {
        primary: 'id',
        foreign: 'cod_municipio_ies',
        foreignTable: '@'
    }
}).addValue({
    name: 'region',
    table: 'regiao',
    tableField: ['nome', 'id'],
    resultField: ['region_name', 'region_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'cod_regiao_ies',
        foreignTable: 'docente_ens_superior'
    }
}).addValue({
    name: 'university',
    table: 'docente_ens_superior',
    tableField: ['cod_ies', 'nome_ies'],
    resultField: ['university_id', 'university_name'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_ies'
    }
}).addValue({
    name: 'upper_adm_dependency',
    table: 'docente_ens_superior',
    tableField: 'par_categoria_administrativa',
    resultField: 'upper_adm_dependency_id',
    where: {
        relation: '=',
        type: 'integer',
        table: 'docente_ens_superior',
        field: 'par_categoria_administrativa'
    }
}).addValue({
    name: 'academic_organization',
    table: 'docente_ens_superior',
    tableField: 'cod_organizacao_academica',
    resultField: 'academic_organization_id',
    where: {
        relation: '=',
        type: 'integer',
        table: 'docente_ens_superior',
        field: 'cod_organizacao_academica'
    }
}).addValue({
    name:'academic_level',
    table: 'docente_ens_superior',
    tableField: 'cod_grau_academico',
    resultField: 'academic_level_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_grau_academico'
    }
}).addValue({
    name:'upper_education_mod',
    table: 'docente_ens_superior',
    tableField: 'cod_modalidade_ensino',
    resultField: 'upper_education_mod_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_modalidade_ensino'
    }
}).addValue({
    name:'teacher_situation',
    table: 'docente_ens_superior',
    tableField: 'par_situacao_docente',
    resultField: 'teacher_situation_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'par_situacao_docente'
    }
}).addValue({
    name:'work_regime',
    table: 'docente_ens_superior',
    tableField: 'cod_regime_trabalho',
    resultField: 'work_regime_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_regime_trabalho'
    }
}).addValue({
    name:'substitute',
    table: 'docente_ens_superior',
    tableField: 'docente_substituto',
    resultField: 'substitute_id',
    where: {
        relation: '=',
        type: 'boolean',
        field: 'docente_substituto'
    }
}).addValue({
    name:'visitor',
    table: 'docente_ens_superior',
    tableField: 'docente_visitante',
    resultField: 'visitor_id',
    where: {
        relation: '=',
        type: 'boolean',
        field: 'docente_visitante'
    }
}).addValue({
    name:'ead_teacher',
    table: 'docente_ens_superior',
    tableField: 'ministra_aula_ead',
    resultField: 'ead_teacher_id',
    where: {
        relation: '=',
        type: 'boolean',
        field: 'ministra_aula_ead'
    }
}).addValue({
    name:'graduation_presential',
    table: 'docente_ens_superior',
    tableField: 'atua_atividade_graduacao_presencial',
    resultField: 'graduation_presential_id',
    where: {
        relation: '=',
        type: 'boolean',
        field: 'atua_atividade_graduacao_presencial'
    }
}).addValue({
    name:'postgraduate_ead_teacher',
    table: 'docente_ens_superior',
    tableField: 'atua_atividade_posgraduacao_distancia',
    resultField: 'postgraduate_ead_teacher_id',
    where: {
        relation: '=',
        type: 'boolean',
        field: 'atua_atividade_posgraduacao_distancia'
    }
}).addValue({
    name:'postgraduate_presential_teacher',
    table: 'docente_ens_superior',
    tableField: 'atua_atividade_posgraduacao_presencial',
    resultField: 'postgraduate_presential_teacher_id',
    where: {
        relation: '=',
        type: 'boolean',
        field: 'atua_atividade_posgraduacao_presencial'
    }
}).addValue({
    name:'teacher_schooling',
    table: 'docente_ens_superior',
    tableField: 'cod_escolaridade_docente',
    resultField: 'teacher_schooling_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_escolaridade_docente'
    }
}).addValue({
    name:'ethnic_group_teacher_ies',
    table: 'docente_ens_superior',
    tableField: 'cod_cor_raca_docente',
    resultField: 'ethnic_group_teacher_ies_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_cor_raca_docente'
    }
}).addValue({
    name:'gender_ies',
    table: 'docente_ens_superior',
    tableField: 'sexo_docente',
    resultField: 'gender_ies_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'sexo_docente'
    }
}).addValue({
    name:'deficiency',
    table: 'docente_ens_superior',
    tableField: 'par_docente_deficiencia',
    resultField: 'deficiency_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'par_docente_deficiencia'
    }
});

teacherEnrollmentApp.get('/', rqf.parse(), (req, res, next) => {

    if ("university" in req.dims) {
        req.sql.field('COUNT(*)', 'total')
        .field("'Brasil'", 'name')
        .field('docente_ens_superior.ano_censo', 'year')
        .from('docente_ens_superior')
        .group('docente_ens_superior.cod_ies')
        .group('docente_ens_superior.ano_censo')
        .order('docente_ens_superior.cod_ies')
        .order('docente_ens_superior.ano_censo')
    }
    else {
        req.sql.field('COUNT(*)', 'total')
        .field("'Brasil'", 'name')
        .field('docente_ens_superior.ano_censo', 'year')
        .from('docente_ens_superior')
        .group('docente_ens_superior.ano_censo')
        .order('docente_ens_superior.ano_censo')
    }

   next();
},  rqf.build(), query, addMissing(rqf), id2str.transform(false), response('teacherEnrollment'));

module.exports = teacherEnrollmentApp;
