process.env.NODE_ENV = 'test';

const chai = require('chai');

const dirtyChai = require('dirty-chai');

chai.use(dirtyChai);

const chaiXml = require('chai-xml');

chai.use(chaiXml);

const chaiHttp = require('chai-http');

const assert = chai.assert;

const expect = chai.expect;

const should = chai.should(); // actually call the function

const libs = `${process.cwd()}/libs`;

const server = require(`${libs}/app`);

chai.use(chaiHttp);
describe('request cub', () => {
    it('should return default query cub', (done) => {
        chai.request(server)
            .get('/api/v1/cub')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('cod_uf');
                res.body.result[0].should.have.property('sigla_uf');
                res.body.result[0].should.have.property('tipo_preco');
                res.body.result[0].should.have.property('preco');
                done();
            });
    });

    it('should list the years', (done) => {
        chai.request(server)
            .get('/api/v1/cub/years')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('year');
                done();
            });
    });

    it('should list the year range', (done) => {
        chai.request(server)
            .get('/api/v1/cub/year_range')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('start_year');
                res.body.result[0].should.have.property('end_year');
                done();
            });
    });

    it('should list the months', (done) => {
        chai.request(server)
            .get('/api/v1/cub/months')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('month');
                done();
            });
    });

    it('should list the years and months', (done) => {
        chai.request(server)
            .get('/api/v1/cub/year_range')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('year');
                res.body.result[0].should.have.property('month');
                done();
            });
    });

    it('should list the price type', (done) => {
        chai.request(server)
            .get('/api/v1/cub/price_type')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('price_type');
                done();
            });
    });
});
