process.env.NODE_ENV = 'test';

const chai = require('chai');

const dirtyChai = require('dirty-chai');

chai.use(dirtyChai);

const chaiXml = require('chai-xml');

chai.use(chaiXml);

const chaiHttp = require('chai-http');

const assert = chai.assert;

const expect = chai.expect;

const should = chai.should(); // actually call the function

const libs = `${process.cwd()}/libs`;

const server = require(`${libs}/app`);

chai.use(chaiHttp);
describe('request daily charge amount', () => {
    it('should list the year range', (done) => {
        chai.request(server)
            .get('/api/v1/daily_charge_amount/year_range')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('start_year');
                res.body.result[0].should.have.property('end_year');
                done();
            });
    });

    it('should list the year range', (done) => {
        chai.request(server)
            .get('/api/v1/daily_charge_amount/years')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('year');
                done();
            });
    });

    it('should list the locations', (done) => {
        chai.request(server)
            .get('/api/v1/daily_charge_amount/location')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('id');
                res.body.result[0].should.have.property('name');
                done();
            });
    });

    it('should list education level short', (done) => {
        chai.request(server)
            .get('/api/v1/daily_charge_amount/education_level_short')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('id');
                res.body.result[0].should.have.property('name');
                done();
            });
    });

    it('should list education level mod', (done) => {
        chai.request(server)
            .get('/api/v1/daily_charge_amount/education_level_mod')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('id');
                res.body.result[0].should.have.property('name');
                done();
            });
    });

    it('should list the dimensions of education_level_short', (done) => {
        chai.request(server)
            .get('/api/v1/daily_charge_amount?dims=education_level_short&filter=min_year:"2015",max_year:"2015",integral_time:"0",period:["3"]')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('year');
                res.body.result[0].should.have.property('education_level_short_id');
                res.body.result[0].should.have.property('education_level_short_name');
                res.body.result[0].should.have.property('average_class_duration');
                res.body.result[0].should.have.property('median_class_duration');
                res.body.result[0].should.have.property('std_class_duration');
                res.body.result[0].should.have.property('fstqt_class_duration');
                res.body.result[0].should.have.property('thdqt_class_duration');
                done();
            });
    });

    it('should list the filter of education level mod', (done) => {
        chai.request(server)
            .get('/api/v1/daily_charge_amount/average?filter=education_level_mod:["3","4","5","6"],integral_time:"0",period:["3"]')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('year');
                res.body.result[0].should.have.property('education_level_mod_id');
                res.body.result[0].should.have.property('education_level_mod_name');
                res.body.result[0].should.have.property('average_class_duration');
                done();
            });
    });

    it('should return 400 with no filters', (done) => {
        chai.request(server)
            .get('/api/v1/daily_charge_amount')
            .end((err, res) => {
                res.should.have.status(400);
                res.should.be.json;
                res.body.should.have.property('error');
                res.body.error.should.be.equal('Wrong/No filter specified');
                done();
            })
    });

    it('should return 400 with no filters', (done) => {
        chai.request(server)
            .get('/api/v1/daily_charge_amount/average?filter=education_level_mod:["3","4","5","6"]')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('year');
                res.body.result[0].should.have.property('education_level_mod_id');
                res.body.result[0].should.have.property('education_level_mod_name');
                res.body.result[0].should.have.property('average_class_duration');
                done();
            });
    });
});
