process.env.NODE_ENV = 'test';

const chai = require('chai');

const dirtyChai = require('dirty-chai');

chai.use(dirtyChai);

const chaiXml = require('chai-xml');

chai.use(chaiXml);

const chaiHttp = require('chai-http');

const assert = chai.assert;

const expect = chai.expect;

const should = chai.should(); // actually call the function

const libs = `${process.cwd()}/libs`;

const server = require(`${libs}/app`);

chai.use(chaiHttp);
describe('request education years', () => {
    it('should list default education years', (done) => {
        chai.request(server)
            .get('/api/v1/education_years')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('id');
                res.body.result[0].should.have.property('name');
                res.body.result[0].should.have.property('schoolYears');
                res.body.result[0].schoolYears.should.be.a('array');
                res.body.result[0].schoolYears[0].should.have.property('id');
                done();
            });
    });
});
