process.env.NODE_ENV = 'test';

const chai = require('chai');

const dirtyChai = require('dirty-chai');

chai.use(dirtyChai);

const chaiXml = require('chai-xml');

chai.use(chaiXml);

const chaiHttp = require('chai-http');

const assert = chai.assert;

const expect = chai.expect;

const should = chai.should(); // actually call the function

const libs = `${process.cwd()}/libs`;

const server = require(`${libs}/app`);

chai.use(chaiHttp);
describe('request gloss enrollment ratio', () => {
    it('should list the year range', (done) => {
        chai.request(server)
            .get('/api/v1/gloss_enrollment_ratio/year_range')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('start_year');
                res.body.result[0].should.have.property('end_year');
                done();
            });
    });

    it('should list the year range', (done) => {
        chai.request(server)
            .get('/api/v1/gloss_enrollment_ratio/years')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('year');
                done();
            });
    });

    it('should return 400 with no filters', (done) => {
        chai.request(server)
            .get('/api/v1/gloss_enrollment_ratio')
            .end((err, res) => {
                res.should.have.status(400);
                res.should.be.json;
                res.body.should.have.property('error');
                res.body.error.should.be.equal('Wrong/No filter specified');
                done();
            })
    });

    it('should list the locations', (done) => {
        chai.request(server)
            .get('/api/v1/gloss_enrollment_ratio/location')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('id');
                res.body.result[0].should.have.property('name');
                done();
            });
    });

    it('should list genders', (done) => {
        chai.request(server)
            .get('/api/v1/gloss_enrollment_ratio/gender')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('id');
                res.body.result[0].should.have.property('name');
                done();
            });
    });

    it('should list education level basic', (done) => {
        chai.request(server)
            .get('/api/v1/gloss_enrollment_ratio/education_level_basic')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('id');
                res.body.result[0].should.have.property('name');
                done();
            });
    });

    it('should list ethnic group', (done) => {
        chai.request(server)
            .get('/api/v1/gloss_enrollment_ratio/ethnic_group')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('id');
                res.body.result[0].should.have.property('name');
                done();
            });
    });

    it('should list the dimensions of education_level_basic', (done) => {
        chai.request(server)
            .get('/api/v1/gloss_enrollment_ratio?dims=education_level_basic&filter=min_year:"2015",max_year:"2015"')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('total');
                res.body.result[0].should.have.property('year');
                res.body.result[0].should.have.property('age_range');
                res.body.result[0].should.have.property('education_level_basic_id');
                res.body.result[0].should.have.property('education_level_basic_name');
                res.body.result[0].should.have.property('partial');
                res.body.result[0].should.have.property('denominator');
                done();
            });
    });

    it('should list the dimensions of ethnic groups and education level basic', (done) => {
        chai.request(server)
            .get('/api/v1/gloss_enrollment_ratio?dims=education_level_basic,gender&filter=min_year:"2015",max_year:"2015"')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('total');
                res.body.result[0].should.have.property('year');
                res.body.result[0].should.have.property('age_range');
                res.body.result[0].should.have.property('education_level_basic_id');
                res.body.result[0].should.have.property('education_level_basic_name');
                res.body.result[0].should.have.property('gender_id');
                res.body.result[0].should.have.property('gender_name');
                res.body.result[0].should.have.property('partial');
                res.body.result[0].should.have.property('denominator');
                done();
            });
    });

    it('should list the filter of education level basic', (done) => {
        chai.request(server)
            .get('/api/v1/gloss_enrollment_ratio?filter=education_level_basic:["1"]')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('total');
                res.body.result[0].should.have.property('year');
                res.body.result[0].should.have.property('partial');
                res.body.result[0].should.have.property('denominator');
                done();
            });
    });

    it('should list the filter of education level basic', (done) => {
        chai.request(server)
            .get('/api/v1/gloss_enrollment_ratio?filter=education_level_basic:["1","2"]')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('total');
                res.body.result[0].should.have.property('year');
                res.body.result[0].should.have.property('partial');
                res.body.result[0].should.have.property('denominator');
                done();
            });
    });

});
