process.env.NODE_ENV = 'test';

const chai = require('chai');

const dirtyChai = require('dirty-chai');

chai.use(dirtyChai);

const chaiXml = require('chai-xml');

chai.use(chaiXml);

const chaiHttp = require('chai-http');

const assert = chai.assert;

const expect = chai.expect;

const should = chai.should(); // actually call the function

const libs = `${process.cwd()}/libs`;

const server = require(`${libs}/app`);

chai.use(chaiHttp);
describe('request rate_school', () => {
    it('should return 400 with no filters', (done) => {
        chai.request(server)
            .get('/api/v1/rate_school')
            .end((err, res) => {
                res.should.have.status(400);
                res.should.be.json;
                res.body.should.have.property('error');
                res.body.error.should.be.equal('Wrong/No filter specified');
                done();
            })
    });

    it('should list the year range', (done) => {
        chai.request(server)
            .get('/api/v1/rate_school/years')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('year');
                done();
            });
    });

    it('should list the source', (done) => {
        chai.request(server)
            .get('/api/v1/rate_school/source')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('source');
                done();
            });
    });

    it('should list the locations', (done) => {
        chai.request(server)
            .get('/api/v1/rate_school/location')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('id');
                res.body.result[0].should.have.property('name');
                done();
            });
    });

    it('should list the ethnic groups', (done) => {
        chai.request(server)
            .get('/api/v1/rate_school/ethnic_group_pnad')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('id');
                res.body.result[0].should.have.property('name');
                done();
            });
    });

    it('should list the age range', (done) => {
        chai.request(server)
            .get('/api/v1/rate_school/age_range')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('id');
                res.body.result[0].should.have.property('name');
                done();
            });
    });

    it('should list the age range', (done) => {
        chai.request(server)
            .get('/api/v1/rate_school?dims=age_range')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('age_range_id');
                res.body.result[0].should.have.property('age_range_name');
                done();
            });
    });

    it('should list the gender', (done) => {
        chai.request(server)
            .get('/api/v1/rate_school/gender')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('id');
                res.body.result[0].should.have.property('name');
                done();
            });
    });


    it('should list the dimensions of ethnic groups', (done) => {
        chai.request(server)
            .get('/api/v1//rate_school?dims=ethnic_group_pnad&filter=min_year:"2015",max_year:"2015",age_range:["1"]')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('ethnic_group_pnad_id');
                res.body.result[0].should.have.property('ethnic_group_pnad_name');
                res.body.result[0].should.have.property('year');
                res.body.result[0].should.have.property('denominator');
                res.body.result[0].should.have.property('partial');
                done();
            });
    });

    it('should list the dimensions of gender', (done) => {
        chai.request(server)
            .get('/api/v1//rate_school?dims=gender&filter=min_year:"2015",max_year:"2015",age_range:["1"]')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('gender_id');
                res.body.result[0].should.have.property('gender_name');
                res.body.result[0].should.have.property('year');
                res.body.result[0].should.have.property('denominator');
                res.body.result[0].should.have.property('partial');
                done();
            });
    });

    it('should list fifth household income', (done) => {
        chai.request(server)
            .get('/api/v1//rate_school/fifth_household_income')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('id');
                res.body.result[0].should.have.property('name');
                done();
            });
    });

    it('should list the dimensions of fifth housebold income', (done) => {
        chai.request(server)
            .get('/api/v1//rate_school?dims=fifth_household_income&filter=min_year:"2015",max_year:"2015",age_range:["1"]')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('fifth_household_income_id');
                res.body.result[0].should.have.property('fifth_household_income_name');
                res.body.result[0].should.have.property('year');
                res.body.result[0].should.have.property('denominator');
                res.body.result[0].should.have.property('partial');
                res.body.result[0].should.have.property('total');
                done();
            });
    });

    it('should list extremes household income', (done) => {
        chai.request(server)
            .get('/api/v1//rate_school/extremes_household_income')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('id');
                res.body.result[0].should.have.property('name');
                done();
            });
    });

    it('should list the dimensions of extremes housebold income', (done) => {
        chai.request(server)
            .get('/api/v1//rate_school?dims=extremes_household_income&filter=min_year:"2015",max_year:"2015",age_range:["1"]')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('extremes_household_income_id');
                res.body.result[0].should.have.property('extremes_household_income_name');
                res.body.result[0].should.have.property('year');
                res.body.result[0].should.have.property('denominator');
                res.body.result[0].should.have.property('partial');
                res.body.result[0].should.have.property('total');
                done();
            });
    });

    it('should list year range', (done) => {
        chai.request(server)
            .get('/api/v1//rate_school/year_range')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('start_year');
                res.body.result[0].should.have.property('end_year');
                done();
            });
    });
});
