process.env.NODE_ENV = 'test';

const chai = require('chai');

const dirtyChai = require('dirty-chai');

chai.use(dirtyChai);

const chaiXml = require('chai-xml');

chai.use(chaiXml);

const chaiHttp = require('chai-http');

const assert = chai.assert;

const expect = chai.expect;

const should = chai.should(); // actually call the function

const libs = `${process.cwd()}/libs`;

const server = require(`${libs}/app`);

chai.use(chaiHttp);
describe('request siope', () => {
    it('should list the years', (done) => {
        chai.request(server)
            .get('/api/v1/siope/years')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('year');
                done();
            });
    });

    it('should list default siope', (done) => {
        chai.request(server)
            .get('/api/v1/siope')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('year');
                res.body.result[0].should.have.property('impostos');
                done();
            });
    });

    it('should list siope with valid filters', (done) => {
        chai.request(server)
            .get('/api/v1/siope?filter=state:41')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('year');
                res.body.result[0].should.have.property('state_id');
                res.body.result[0].should.have.property('fundeb');
                res.body.result[0].should.have.property('impostos');
                done();
            });
    });

    it('should list siope with valid dimensions', (done) => {
        chai.request(server)
            .get('/api/v1/siope?dims=state')
            .end((err, res) => {
                res.should.have.status(200);
                res.should.be.json;
                res.body.should.have.property('result');
                res.body.result.should.be.a('array');
                res.body.result[0].should.have.property('year');
                res.body.result[0].should.have.property('state_id');
                res.body.result[0].should.have.property('fundeb');
                res.body.result[0].should.have.property('impostos');
                res.body.result[0].should.have.property('state_name');
                done();
            });
    });

});
