const express = require('express');
const cookieParser = require('cookie-parser');
const bodyParser = require('body-parser');
const methodOverride = require('method-override');
const cors = require('cors');
const squel = require('squel');

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

process.env.NODE_ENV = process.env.NODE_ENV || 'development';
const config = require(`${libs}/config`);

const app = express();

const api_v1 = require('./routes_v1/api');
const api_v2 = require('./routes_v2/api');

const passport = require('passport');

require(`${libs}/middlewares/passport`);

app.use(bodyParser.json({limit: '50mb'}));
app.use(bodyParser.urlencoded({ extended: true, limit: '50mb' }));
app.use(cookieParser());
// Enable Cross-Origin Resource Sharing (CORS)
app.use(cors());
app.use(methodOverride());
// Middleware tha adds the squel object to req
app.use((req, res, next) => {
    req.resetSql = () => {
        req.sql = squel.select();
        // HACK to know wich table we are using
        req.sql.oldFrom = req.sql.from;
        req.sql.from = (name, alias = null) => {
            req.sql.oldFrom(name, alias || null);
            req.sql.tableFrom = name;
            return req.sql;
        };
    };
    req.resetSql();

    req.sql.oldClone = req.sql.clone;
    req.sql.clone = () => {
        let cloned = req.sql.oldClone();
        cloned.oldFrom = cloned.from;
        cloned.from = (name, alias = null) => {
            cloned.oldFrom(name, alias || null);
            cloned.tableFrom = name;
            return cloned;
        };
        return cloned;
    };
    next();
});
app.use(passport.initialize());
app.use(passport.session());

app.use((req, res, next) => {
    res.setHeader('Last-Modified', (new Date()).toUTCString());
    next();
});
// Mounts all API routes under /api/v1
app.use('/api/v1', api_v1);

// Mounts all API routes under /api/v2
app.use('/api/v2', api_v2);

// Catch 404 and forward to error handler
app.use((req, res, next) => {
    res.status(404);
    log.error('%s %d %s', req.method, res.statusCode, req.url);
    res.json({ error: 'Error 404: Page not found' }).end();
});

// Express' default error handler
app.use((err, req, res, next) => {
    res.status(err.status || 500);
    log.error('%s %d %s', req.method, res.statusCode, err.message);
    log.error(`Route: ${req.originalUrl}`);
    log.error(err);
    res.json({ error: err.message }).end();
});

module.exports = app;
