const MonetDBPool = require('monetdb-pool');

const libs = `${process.cwd()}/libs`;

const config = require(`${libs}/config`);

// Connection options
const poolOptions = {
    nrConnections: config.monetdb.nrConnections,
};

// Configuration options
const options = {
    host: config.monetdb.host,
    port: config.monetdb.port,
    dbname: config.monetdb.dbname,
    user: config.monetdb.user,
    password: config.monetdb.password,
};

// Connection singleton
const conn = new MonetDBPool(poolOptions, options);
conn.connect();

module.exports = conn;
