/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

function binarySearch(value, vector, a, b) {
    // Search for a value in a vector returning an object with a boolean 'found' and the the position of where the element is/should be at.

    if (value === null) {       // null should be last in the vector
        if (vector[b-1] === null) return {found: true, pos: b-1}
        else return {found: false, pos: b}
    }

    while (a < b) {
        let mid = Math.floor((b-a)/2) + a

        if (vector[mid] === value)
            return {found: true, pos: mid}
        else if (vector[mid] > value || vector[mid] === null)       // null should be the last element of the vector
            b = mid
        else
            a = mid+1
    }

    return {found: false, pos: a}
}

module.exports = function addMissing(rqf) {
    return (req, res, next) => {
        let dims = Object.keys(req.dims).filter(i => { return i !== 'size'; });
        // FIXME: No momento, só funciona para duas dimensões (padrão para o LDE)
        if (req.result.length === 0 || dims.length === 0) return next();

        if (dims.length === 1)      // If there is only one dimension we add year as a dimension, since it is the standard dim.
            dims.splice(0, 0, 'min_year')

        let resultOriginal = req.result;

        let dimsValues = {};        // Object with the id's of dims
        let dimsNames = {}          // Object the names of the dims
        resultOriginal.forEach((r) => {         // First pass to get all the dimensions fields
            dims.forEach((dim) => {
                let rqfName = rqf.fieldValues[dim].resultField;             // rqf with the id value
                let secondaryRqfName = rqfName.slice(0, -2) + 'name'        // rqf with the 'name' value
                if (typeof rqfName === 'object') {                          // if the resultField is an array we verify what the rqf with the name field is
                    rqfName.forEach((name) => {
                        if (name.includes("_id"))
                            rqfName = name;
                        else
                            secondaryRqfName = name;
                    })
                }

                if (typeof dimsValues[rqfName] === 'undefined') {       // dim wasn't added yet, so we create a new array for it.
                    dimsValues[rqfName] = [];
                    dimsNames[secondaryRqfName] = [];
                }

                if (dimsValues[rqfName].indexOf(r[rqfName]) === -1) {
                    if (['school', 'arrangement'].includes(dim)) {      // those should be ordered by its name
                        let namePosition = binarySearch(r[secondaryRqfName], dimsNames[secondaryRqfName], 0, dimsNames[secondaryRqfName].length)    // find the position of the name in alphabetical order and keep the names vector ordered
                        dimsValues[rqfName].splice(namePosition.pos, 0, r[rqfName]);
                        dimsNames[secondaryRqfName].splice(namePosition.pos, 0, r[secondaryRqfName]);
                    }
                    else {          // order by id
                        let idPosition = binarySearch(r[rqfName], dimsValues[rqfName], 0, dimsValues[rqfName].length)
                        dimsValues[rqfName].splice(idPosition.pos, 0, r[rqfName]);
                        dimsNames[secondaryRqfName].splice(idPosition.pos, 0, r[secondaryRqfName])
                    }

                }
            })
        });

        if (dims[0] === 'min_year')         // year should be sorted by its value
            dimsValues['year'].sort();

        let newResult = [];
        let rqfName = Object.keys(dimsValues)[0];
        let rqfName2 = Object.keys(dimsValues)[1];

        let nameDim1 = Object.keys(dimsNames)[0];
        let nameDim2 = Object.keys(dimsNames)[1];

        dimsValues[rqfName].forEach((dim1Value, i) => {     // add entries with 0's for all the combinations between dims
            dimsValues[rqfName2].forEach((dim2Value, j) => {
                let newEntry = Object.assign({}, resultOriginal[0], { [rqfName]: parseInt(dim1Value, 10), [rqfName2]: parseInt(dim2Value, 10), total: 0 });
                if (newEntry.hasOwnProperty("average"))
                    newEntry.average = 0;
                if (newEntry.hasOwnProperty("median"))
                    newEntry.median = 0;
                if (newEntry.hasOwnProperty("stddev"))
                    newEntry.stddev = 0;
                if (newEntry.hasOwnProperty("first_qt"))
                    newEntry.first_qt = 0;
                if (newEntry.hasOwnProperty("third_qt"))
                    newEntry.third_qt = 0;

                newEntry[nameDim1] = dimsNames[nameDim1][i]
                newEntry[nameDim2] = dimsNames[nameDim2][j]

                newResult.push(newEntry);
            })
        })

        resultOriginal.forEach((r) => {             // match entries that exists
            let indexDim1 = dimsValues[rqfName].indexOf(r[rqfName])
            let indexDim2 = dimsValues[rqfName2].indexOf(r[rqfName2])
            newResult[indexDim1*dimsValues[rqfName2].length + indexDim2] = r;
        })

        req.result = newResult




        // newResult[rqfName] = {};
        // dimsValues[rqfName].forEach((value) => {
        //     let secondDim = {};

        //     dimsValues[rqfName2].forEach((dValue) => {
        //         secondDim[dValue] = false;
        //     });

        //     newResult[rqfName][value] = {};
        //     newResult[rqfName][value][rqfName2] = secondDim;
        // });
        // // console.log(newResult.year, "\n\n\n!!!!", resultOriginal, rqfName, rqfName2)
        // resultOriginal.forEach((r) => {
        //     newResult[r[rqfName]]
        // })

        // resultOriginal.forEach((r) => {
        //     let resultDim1 = r[rqfName];
        //     let resultDim2 = r[rqfName2];
        //     newResult[rqfName][resultDim1][rqfName2][resultDim2] = true;
        // });

        // // console.log(newResult.year, "\n\n\n!!!!", resultOriginal, rqfName, rqfName2)

        // Object.keys(newResult[rqfName]).forEach((dim1Value) => {
        //     Object.keys(newResult[rqfName][dim1Value][rqfName2]).forEach((dim2Value) => {
        //         let value = newResult[rqfName][dim1Value][rqfName2][dim2Value];
        //         if (!value) {
        //             let newEntry = Object.assign({}, resultOriginal[0], { [rqfName]: parseInt(dim1Value, 10), [rqfName2]: parseInt(dim2Value, 10), total: 0 });
        //             if (newEntry.hasOwnProperty("average"))
        //                 newEntry.average = 0;
        //             if (newEntry.hasOwnProperty("median"))
        //                 newEntry.median = 0;
        //             if (newEntry.hasOwnProperty("stddev"))
        //                 newEntry.stddev = 0;
        //             if (newEntry.hasOwnProperty("first_qt"))
        //                 newEntry.first_qt = 0;
        //             if (newEntry.hasOwnProperty("third_qt"))
        //                 newEntry.third_qt = 0;
        //             // resultOriginal.push(newEntry);
        //             let index = 0;
        //             for (let i = 0; i < resultOriginal.length; ++i) {
        //                 let r = resultOriginal[i];
        //                 index = i;
        //                 if (r[rqfName] > newEntry[rqfName]) break;
        //                 if (r[rqfName] == newEntry[rqfName] && r[rqfName2] > newEntry[rqfName2]) break;
        //             }
        //             if (newEntry.dim1Value == undefined && newEntry.dim2Value == undefined) {
        //                 resultOriginal = [...resultOriginal.slice(0, index), newEntry, ...resultOriginal.slice(index, resultOriginal.length)];
        //             }
        //         }
        //     });
        // });

        // req.result = resultOriginal;
        // }


        // Quando é série historica, é uma dimensão com max e min year nos filtros.
        // else if (dims.length == 1 && req.filter.min_year != req.filter.max_year) {
        //     let result = req.result;

        //     //Pega os valores da dimensão
        //     let dimsValues = {};
        //     result.forEach((r) => {

        //         // para cada dimensão
        //         dims.forEach((dim) => {

        //             // pega o nome da dimensao
        //             let rqfName = rqf.fieldValues[dim].resultField;
        //             if (rqfName[0] == "university_id" || rqfName[1] == "university_id") {
        //                 rqfName = "university_id"
        //             };
        //             let rqfName2 = "year"
        //             //se n existir o array é uma nova dimensão, então cria os arrays para colocar os ids
        //             if(typeof dimsValues[rqfName] === 'undefined') {
        //                 dimsValues[rqfName] = [];
        //             }
        //             if(typeof dimsValues[rqfName2] === 'undefined') {
        //                 dimsValues[rqfName2] = [];
        //             }
        //             //se já existe, verifica se está no vetor, se n estiver, adiciona o id
        //             if(dimsValues[rqfName].indexOf(r[rqfName]) === -1) {
        //                 dimsValues[rqfName].push(r[rqfName]);
        //             }
        //             //se já existe, verifica se está no vetor, se n estiver, adiciona o ano
        //             if(dimsValues[rqfName2].indexOf(r[rqfName2]) === -1) {
        //                 dimsValues[rqfName2].push(r[rqfName2]);
        //             }
        //         })
        //     })

        //     //ordena os anos
        //     dimsValues["year"] = dimsValues["year"].sort();
        //     // console.log(dimsValues);

        //     let dimsValuesKey = Object.keys(dimsValues);
        //     // console.log(dimsValuesKey);

        //     let firstDim = dimsValuesKey[0];
        //     let secondDim = dimsValuesKey[1];
        //     let count = 0;

        //     //Permuta as dimensões em ordem, agora verifica se existe no vetor de resultados.
        //     dimsValues[firstDim].forEach((fDim) => {
        //         dimsValues[secondDim].forEach((sDim) => {

        //              //caso o object chegou ao final e ainda temos coisas para adicionar
        //              if (typeof result[count] === 'undefined' ) {
        //                  let newEntry = Object.assign({}, result[count - 1]);
        //                  newEntry[firstDim] = fDim;
        //                  newEntry[secondDim] = sDim
        //                  newEntry["total"] = 0;
        //                  let newResult = [...result.slice(0, count), newEntry, ...result.slice(count, result.length)];
        //                  result = newResult;
        //                  count++;
        //              }

        //              //   console.log(fDim,result[count][firstDim],sDim,result[count][secondDim])

        //             //está no vetor, aumenta o contador
        //             else if ((fDim == result[count][firstDim]) && (sDim == result[count][secondDim])) {
        //                 // console.log("A Entrada Existe");
        //                 count++;

        //             //se não existe no objecto, vamos ordernar
        //             } else {

        //                 //  console.log("A entrada " + fDim + " "+ sDim + " Não existe");

        //                 //Se não existe pega uma copia do próximo, onde a primeira dimensão seja igual
        //                 if (result[count][firstDim] == fDim) {
        //                     let newEntry = Object.assign({}, result[count]);
        //                     newEntry[firstDim] = fDim;
        //                     newEntry[secondDim] = sDim
        //                     newEntry["total"] = 0;
        //                     let newResult = [...result.slice(0, count), newEntry, ...result.slice(count, result.length)];
        //                     result = newResult;
        //                     count++;
        //                 //se não existe pega uma copia do anterior, onde a primeira dimensão seja igual
        //                 } else if (result[count - 1][firstDim] == fDim) {
        //                      let newEntry = Object.assign({}, result[count - 1]);
        //                     newEntry[firstDim] = fDim;
        //                     newEntry[secondDim] = sDim
        //                     newEntry["total"] = 0;
        //                     let newResult = [...result.slice(0, count - 1), newEntry, ...result.slice(count - 1, result.length)];
        //                     result = newResult;
        //                     count++;
        //                 }
        //             }
        //         });
        //     });
        //     req.result = result;
        // }
        next();
    };
};
