const express = require('express');

const pubApp = express();

const libs = `${process.cwd()}/libs`;

const PermissionRole = require(`${libs}/models/permissionRole`)

const mapPermission = {
    'criar publicacao': '1',
    'editar publicacao': '2',
    'apagar publicacao': '3',
    'criar atividade': '4',
    'editar atividade': '5',
    'apagar atividade': '6',
}
 
function authorized(permission) {
  return async function (req, res, next) {
    const permission_id = mapPermission[permission]
    const userRole = req.user.role_id; // Assuming user role is stored in req.user.role
    const hasPermission = await PermissionRole.findOne({where:{role_id:userRole, permission_id: permission_id}}).catch(function (err) {
      if (err) {
          log.error(err);
          return next({ err });
      }
  });
    if (hasPermission) {
      // User has permission, proceed to next middleware or route handler
      next();
    } else {
      // User does not have permission, return unauthorized response
      res.status(403).json({ message: 'Unauthorized' });
    }
  };
}

module.exports = authorized

