const passport = require('passport');
const ClientPasswordStrategy = require('passport-oauth2-client-password');
const BearerStrategy = require('passport-http-bearer').Strategy;

const libs = `${process.cwd()}/libs`;
const config = require(`${libs}/config`);

const User = require(`${libs}/models/user`);
const Client = require(`${libs}/models/client`);
const AccessToken = require(`${libs}/models/accessToken`);


passport.use(new ClientPasswordStrategy(
    function (client_id, client_secret, done) {
        Client.findOne({
            where: { id: client_id }
        }).then(function (client) {
            if (!client) {
                console.log("Erro de cliente");
                return done(null, false);
            }
            if (client.client_secret !== client_secret) {
                console.log("Erro de Chave Secreta");
                return done(null, false);
            }
            return done(null, client);
        }).catch(function (error) {
            return done(error);
        });
    }
));

passport.use(new BearerStrategy(async (accessToken, done) => {
    const token = await AccessToken.findOne({ where: { token: accessToken } })
    if (!token) {
        console.log("ERRO Token");
        return done(null, false);
    }

    if (Math.round((Date.now() - token.created) / 1000) > config.security.tokenLife) {
        AccessToken.destroy({where:{ token: accessToken} }).catch(function (err) {
            if (err) {
                log.error(err);
                return next({ err });
            }
        });

        return done(null, false, { msg: 'Token expired' });
    }
    User.findByPk(token.user_id).then(function (usuario) {
        if (!usuario) {
            console.log("ERRO NAO USUARIO");
            return done(null, false, { msg: 'Unknown user' });
        }
        var info = { scope: '*' };
        done(null, usuario, info);
    })
}));
