const Sequelize = require("sequelize");
const db = require('../db/postgres.js');
const libs = `${process.cwd()}/libs`;

var Activity = db.define("Activity",{
    id:{
        type: Sequelize.STRING,
        allowNull:false,
        unique: true,
        primaryKey: true
    },
    type:{
        type: Sequelize.STRING,
        allowNull:false
    },
    title:{
        type: Sequelize.STRING,
        allowNull:false,
    },
    subtitle:{
        type: Sequelize.STRING
    },
    date:{
        type: Sequelize.DATE,
        allowNull:false
    },
    date_final:{
        type: Sequelize.DATE,
        allowNull:false
    },
    authors:{
        type: Sequelize.STRING,
    },
    text:{
        type: Sequelize.STRING,
        allowNull: false
    },
    name_headline:{
        type: Sequelize.STRING,
        allowNull:false
    },
    resume_headline:{
        type:Sequelize.STRING,
        allowNull:false
    },
    date_headline:{
        type: Sequelize.STRING,
        allowNull:false
    },
    local_headline:{
        type:Sequelize.STRING,
        allowNull:false
    },
    additional_headline:{
        type:Sequelize.STRING
    },
    is_draft:{
        type:Sequelize.BOOLEAN,
        allowNull:false,
        defaultValue: true
    },
    is_headline:{
        type:Sequelize.BOOLEAN,
        allowNull: false,
        defaultValue: false
    }

},
{timestamps: false});

Activity.generateObjectId = function(){
    var timestamp = (new Date().getTime() / 1000 | 0).toString(16);
    return timestamp + 'xxxxxxxxxxxxxxxx'.replace(/[x]/g, function() {
        return (Math.random() * 16 | 0).toString(16);
    }).toLowerCase();
}

const setObjectId = act => {
   act.id = Activity.generateObjectId()
};

Activity.beforeCreate(setObjectId);

module.exports = Activity;