const Sequelize = require("sequelize");
const libs = `${process.cwd()}/libs`;
const db = require('../db/postgres.js');
const User = require(`${libs}/models/user`);
const uuid = require('node-uuid');

var ResetToken = db.define("ResetToken",{
    user_id: {
        type: Sequelize.STRING,
        allowNull: false
    },
    token:{
        type: Sequelize.STRING, 
        allowNull: false,
        unique: true,
        primaryKey: true
    },
    reset:{
        type: Sequelize.BOOLEAN,
        allowNull: false,
        defaultValue: false
    },
    created_at:{
        type: Sequelize.DATE,
        defaultValue: Date.now
    }},
    {timestamps: false}
);

ResetToken.prototype.hasExpired = function () {
    var now = new Date();
    console.log(now);
    console.log(this.created_at);
    console.log(now - this.created_at);
    return (now - this.created_at) > 86400; //Expire if token is 1 day old
};

ResetToken.hasOne(User,{ foreignKey: 'id' });


module.exports = ResetToken
