const Sequelize = require("sequelize");
const db = require('../db/postgres.js')
const User = require(`./user.js`);

var Simulation = db.define("Simulation",{
    id:{
        type: Sequelize.INTEGER, 
        allowNull: false,
        autoIncrement: true,
        unique: true,
        primaryKey: true
    },
    user_id: {
        type: Sequelize.STRING, 
        allowNull: false
    },
    content:{
        type: Sequelize.STRING,
        allowNull: false
    },
    name: {
        type: Sequelize.STRING,
    },
    created_at:{
        type: Sequelize.DATE,
        allowNull: false,
        defaultValue: Date.now
    },
    updated_at: {
        type: Date,
        required: true,
        default: Date.now
    }
},
{timestamps: false});

Simulation.hasOne(User,{ foreignKey: 'id' });

module.exports = Simulation;
