/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');
const { result } = require('lodash');

const employeesAggregateApp = express.Router();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const aggregateData = require(`${libs}/middlewares/aggregateData`);

const id2str = require(`${libs}/middlewares/id2str`);

const config = require(`${libs}/config`);

const addMissing = require(`${libs}/middlewares/addMissing`);

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

employeesAggregateApp.use(cache('15 day'));

let rqf = new ReqQueryFields();

employeesAggregateApp.get('/years', (req, res, next) => {
    req.sql.from('escola')
    .field('DISTINCT escola.ano_censo', 'year')
    .where('escola.ano_censo >= 2021')
    next();
}, query, response('years'));

employeesAggregateApp.get('/education_level_mod_doc', (req, res, next) => {
    req.result = []

    for (let i = 1; i <= 8; i++) {
        req.result.push({
            id: i, name: id2str.educationLevelModDoc(i)
        });
    }
    next();
}, response('education_level_mod_doc'));

employeesAggregateApp.get('/special_education_doc', (req, res, next) => {
    req.result = []

    for (let i = 1; i <= 2; i++) {
        req.result.push({
            id: i, name: id2str.specialEducationDoc(i)
        });
    }

    next();
}, response('special_education_doc'));


rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'region',
    table: 'regiao',
    tableField: ['nome', 'id'],
    resultField: ['region_name', 'region_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'regiao_id',
        foreignTable: 'escola'
    }
}).addValue({
    name: 'mesoregion',
    table: 'municipio',
    tableField: ['nome_mesorregiao', 'mesorregiao_id'],
    resultField: ['mesoregion_name', 'mesoregion_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'mesorregiao_id',
        table: 'municipio'
    },
    join: {
        primary: 'id',
        foreign: 'municipio_id',
        foreignTable: 'escola'
    }
}).addValue({
    name: 'microregion',
    table: 'municipio',
    tableField: ['nome_microrregiao', 'microrregiao_id'],
    resultField: ['microregion_name', 'microregion_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'microrregiao_id',
        table: 'municipio'
    },
    join: {
        primary: 'id',
        foreign: 'municipio_id',
        foreignTable: 'escola'
    }
}).addValue({
    name: 'min_year',
    table: 'escola',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '>=',
        type: 'integer',
        field: 'ano_censo',
    },
}).addValue({
    name: 'max_year',
    table: 'escola',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '<=',
        type: 'integer',
        field: 'ano_censo',
    },
}).addValueToField({
    name: 'state',
    table: 'estado',
    tableField: ['nome', 'id'],
    resultField: ['state_name', 'state_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'estado_id',
        foreignTable: 'escola'
    }
}, 'dims').addValueToField({
    name: 'state',
    table: 'estado',
    tableField: 'nome',
    resultField: 'state_name',
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'estado_id',
        foreignTable: 'escola'
    }
}, 'filter').addValueToField({
    name: 'city',
    table: 'municipio',
    tableField: ['nome', 'id'],
    resultField: ['city_name', 'city_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'municipio_id',
        foreignTable: 'escola'
    }
}, 'dims').addValueToField({
    name: 'city',
    table: 'municipio',
    tableField: 'nome',
    resultField: 'city_name',
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'municipio_id',
        foreignTable: 'escola'
    }
}, 'filter').addValueToField({
    name: 'school',
    table: 'escola',
    tableField: ['nome_escola', 'id'],
    resultField: ['school_name', 'school_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: ['id', 'ano_censo'],
        foreign: ['escola_id', 'ano_censo'],
        foreignTable: 'escola'
    }
}, 'dims').addValueToField({
    name: 'locale_id',
    table: 'escola',
    tableField: 'localizacao_id',
    resultField: 'locale_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'localizacao_id'
    }
}, 'dims').addValueToField({
    name: 'school_id',
    table: 'escola',
    tableField: 'id',
    resultField: 'school_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: ['id', 'ano_censo'],
        foreign: ['escola_id', 'ano_censo'],
        foreignTable: 'escola'
    }
}, 'dims').addValueToField({
    name: 'school',
    table: 'escola',
    tableField: 'nome_escola',
    resultField: 'school_name',
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: ['id', 'ano_censo'],
        foreign: ['escola_id', 'ano_censo'],
        foreignTable: 'escola'
    }
}, 'filter');

// Return all cities
employeesAggregateApp.get('/', rqf.parse(), rqf.build(), (req, res, next) => {

    if ((req.query.filter && !req.query.filter.includes('school')) || req.query.filter == undefined)
        throw 'Filtro escola deve ser selecionado.';

    if (req.query.dims && req.query.dims.includes('education_level_mod_doc')) {
        req.sql.from('escola')
        .field('SUM(escola.qt_doc_inf_cre)', 'total_cre')
        .field('SUM(escola.qt_doc_inf_pre)', 'total_pre')
        .field('SUM(escola.qt_doc_fund_ai)', 'total_fund_ai')
        .field('SUM(escola.qt_doc_fund_af)', 'total_fund_af')
        .field('SUM(escola.qt_doc_med)', 'total_med')
        .field('SUM(escola.qt_doc_prof)', 'total_prof')
        .field('SUM(escola.qt_doc_eja_fund)', 'total_eja_fund')
        .field('SUM(escola.qt_doc_eja_med)', 'total_eja_med')
        .field('escola.ano_censo', 'year')
        .group('escola.ano_censo')
        .order('escola.ano_censo')
        .where('escola.situacao_funcionamento_pareada = 1 and (escola.ensino_regular = 1 or escola.ensino_eja = 1 or escola.educacao_profissional = 1)');
    }
    else if (req.query.dims && req.query.dims.includes('special_education_doc')) {
        req.sql.from('escola')
        .field('SUM(escola.qt_doc_esp_cc)', 'total_esp_cc')
        .field('SUM(escola.qt_doc_esp_ce)', 'total_esp_ce')
        .field('escola.ano_censo', 'year')
        .group('escola.ano_censo')
        .order('escola.ano_censo')
        .where('escola.situacao_funcionamento_pareada = 1 and (escola.ensino_regular = 1 or escola.ensino_eja = 1 or escola.educacao_profissional = 1)');
    }
    else {
        req.sql.from('escola')
        .field('SUM(escola.qt_doc_bas)', 'total')
        .field('escola.ano_censo', 'year')
        .group('escola.ano_censo')
        .order('escola.ano_censo')
        .where('escola.situacao_funcionamento_pareada = 1 and (escola.ensino_regular = 1 or escola.ensino_eja = 1 or escola.educacao_profissional = 1)');
    }
    next();
}, query, aggregateData, id2str.transform(false), response('employees_aggregate'));

module.exports = employeesAggregateApp;
