/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const stateApp = express.Router();

const libs = `${process.cwd()}/libs`;

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const config = require(`${libs}/config`); 

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

let rqf = new ReqQueryFields();

stateApp.use(cache('15 day'));

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addValue({
    name: 'id',
    table: 'estado',
    tableField: 'id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    }
}).addValue({
    name: 'id_not',
    table: 'estado',
    tableField: 'id',
    where: {
        relation: '<>',
        type: 'integer',
        field: 'id'
    }
}).addValue({
    name: 'region',
    table: 'regiao',
    tableField: ['nome', 'id'],
    resultField: ['region_name', 'region_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'regiao_id',
        table: 'estado'
    },
    join: {
        primary: 'id',
        foreign: 'regiao_id',
        foreignTable: 'estado'
    }
}).addField({
    name: 'search',
    field: false,
    where: true
}).addValueToField({
    name: 'name',
    table: 'estado',
    tableField: 'nome',
    where: {
        relation: 'LIKE',
        type: 'string',
        field: 'nome'
    }
}, 'search');

stateApp.get('/', rqf.parse(), rqf.build(), (req, res, next) => {
    req.sql.from('estado')
        .field('estado.id').group('estado.id')
        .field('regiao_id', 'region_id').group('regiao_id')
        .field('estado.nome', 'name').group('estado.nome')
        .field('estado.sigla', 'abbreviation').group('estado.sigla')
        .field('estado.longitude', 'longitude').group('estado.longitude')
        .field('estado.latitude', 'latitude').group('estado.latitude')
				.where('estado.id <> 99');
    next();
}, query, response('state'));

module.exports = stateApp;
