const express = require('express');

const verifyTokenApp = express.Router();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const VerificationToken = require(`${libs}/models/verificationToken`);

const User = require(`${libs}/models/user`);

verifyTokenApp.get('/:token', async (req, res, next) => {
    let token = req.params.token;
    let vToken = await VerificationToken.findOne({ where: { token: token } }).catch(function (err) {
        if (err) {
            log.error(err);
            return next({ err });
        }
    })
    if (!vToken) {
        // TODO: generate new verification token
        res.statusCode = 404;
        return next({ msg: 'Token not found', status: 404 });
    }
    let _user = await User.findByPk(vToken.user_id).catch(function (err) {
        if (err) {
            log.error(err);
            return next({ err });
        }
    }) 
    if(!_user){
        return done(null, false); 
    }
    await _user.update({verified:true});
    await _user.save().catch(err => {
        if (err) {
          log.error(err);
          return next({ message: 'Erro ao atualizar usuário' });
        }})
    vToken.verified = true;
    await vToken.save().catch(err => {
        if (err) {
            log.error(err);
            next(err);
        }
    });
    let u = _user.toJSON();
    delete u['salt'];
    delete u['hashed_password'];
    res.json({ msg: 'User verified', u });
});

module.exports = verifyTokenApp;
