/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const cityApp = express.Router();

const libs = `${process.cwd()}/libs`;

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const config = require(`${libs}/config`); 

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

let rqf = new ReqQueryFields();

cityApp.use(cache('15 day'));

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addValue({
    name: 'id',
    table: 'municipio',
    tableField: 'id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    }
}).addValue({
    name: 'state',
    table: 'estado',
    tableField: ['nome', 'id'],
    resultField: ['state_name', 'state_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'estado_id',
        table: 'municipio'
    },
    join: {
        primary: 'id',
        foreign: 'estado_id',
        foreignTable: 'municipio'
    }
}).addValue({
    name: 'state_not',
    table: 'estado',
    tableField: ['nome', 'id'],
    resultField: ['state_name', 'state_id'],
    where: {
        relation: '<>',
        type: 'integer',
        field: 'estado_id',
        table: 'municipio'
    },
    join: {
        primary: 'id',
        foreign: 'estado_id',
        foreignTable: 'municipio'
    }
}).addField({
    name: 'search',
    field: false,
    where: true
}).addValueToField({
    name: 'name',
    table: 'municipio',
    tableField: 'nome',
    where: {
        relation: 'LIKE',
        type: 'string',
        field: 'nome'
    }
}, 'search').addValue({
    name: 'mesoregion',
    table: 'municipio',
    tableField: 'mesorregiao_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'mesorregiao_id'
    }
}).addValue({
    name: 'microregion',
    table: 'municipio',
    tableField: 'microrregiao_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'microrregiao_id'
    }
}).addValueToField({
    name: 'region',
    table: 'estado',
    tableField: 'regiao_id',
    resultField: 'region_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'regiao_id',
        table: 'estado'
    },
    join: {
        primary: 'id',
        foreign: 'estado_id',
        foreignTable: 'municipio'
    }
}, 'filter');

// Return all cities
cityApp.get('/', rqf.parse(), rqf.build(), (req, res, next) => {
    req.sql.from('municipio')
    .field('municipio.nome', 'name')
    .field('municipio.id')
    .field('municipio.estado_id', 'state_id')
    .field('municipio.longitude', 'longitude')
    .field('municipio.latitude', 'latitude')
    .field('municipio.mesorregiao_id', 'mesoregion_id')
    .field('municipio.microrregiao_id', 'microregion_id');
    next();
}, query, response('city'));


module.exports = cityApp;
