/*
Copyright (C) 2021 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const messageApp = express.Router();

const email = require(`../middlewares/email`);

const log = require(`../log`)(module);

messageApp.post('/', (req, res, next) => {
    var reqName = req.body.name
    var reqEmail = req.body.email
    var reqContents = req.body.contents
    var reqOrigin = req.body.origin ? req.body.origin : "";

    var sub = "Contato " + reqOrigin
    let mailOptions = {
	to: ["dadoseducacionais@ufpr.br", reqEmail], 
	from: `\"${reqName}\" <dadoseducacionais@ufpr.br>`,
	text: reqContents,
        subject: sub
    }

    email(mailOptions, (err, info) => {
        if(err) {
            log.error(err);
            console.log(err);
            res.status(500).json({msg: 'Undelivered Contact Mail'});
        } else {
            log.info(`Message ${info.messageId} sent: ${info.response}`);
            res.json({msg: 'Contact Mail Successfully Delivered'});
        }
    });
})

module.exports = messageApp;