/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const simcaqFirstReportApp = express.Router();

const libs = `${process.cwd()}/libs`;

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const reqBody = require(`${libs}/middlewares/reqBody`);

const config = require(`${libs}/config`); 

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

let rqf = new ReqQueryFields();

const id2str = require(`${libs}/middlewares/id2str`);

simcaqFirstReportApp.use(cache('15 day'));

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'year',
    table: 'simcaq_relatorio_1',
    tableField: 'ano_censo',
    where: {
        relation: '=',
        type: 'integer',
        field: 'ano_censo'
    }
}).addValue({
    name: 'adm_dependency',
    table: 'simcaq_relatorio_1',
    tableField: 'dependencia_adm_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'dependencia_adm_id'
    }
}).addValue({
    name: 'city',
    table: 'municipio',
    tableField: ['nome', 'id'],
    resultField: ['city_name', 'city_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'municipio_id',
        foreignTable: 'simcaq_relatorio_1'
    }
}, 'dims').addValue({
    name: 'state',
    table: 'estado',
    tableField: ['nome', 'id'],
    resultField: ['state_name', 'state_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'estado_id',
        foreignTable: 'simcaq_relatorio_1'
    }
}, 'dims').addValue({
    name: 'school',
    table: 'escola_agregada',
    tableField: 'id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'escola_id',
        foreignTable: 'simcaq_relatorio_1'
    }
}, 'dims').addValue({
    name: 'location',
    table: 'simcaq_relatorio_1',
    tableField: 'localizacao_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'localizacao_id'
    }
}).addValue({
    name: 'education_level_short_id',
    table: 'simcaq_relatorio_1',
    tableField: 'etapa',
    where: {
        relation: '=',
        type: 'integer',
        field: 'etapa'
    }
}).addValue({
    name: 'shift_id',
    table: 'simcaq_relatorio_1',
    tableField: 'turno',
    where: {
        relation: '=',
        type: 'integer',
        field: 'turno'
    }
});

simcaqFirstReportApp.get('/', rqf.parse(), rqf.build(), (req, res, next) => {
    req.sql.from('simcaq_relatorio_1')
        .field('simcaq_relatorio_1.etapa', 'education_level_short_id')
        .field('simcaq_relatorio_1.turno', 'shift_id')
        .field('simcaq_relatorio_1.localizacao_id', 'location_id')
        .field('SUM(simcaq_relatorio_1.num_matriculas)', 'num_enrollments')
        .field('SUM(simcaq_relatorio_1.num_escolas)', 'num_schools')
        .field('ano_censo', 'year')
        .group('ano_censo')
        .group('simcaq_relatorio_1.etapa')
        .group('simcaq_relatorio_1.turno')
        .group('simcaq_relatorio_1.localizacao_id');
    next();
}, query, id2str.transform(), response('simcaqFirstReport'));

module.exports = simcaqFirstReportApp;
