/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const simcaqTeacherCityPlanApp = express.Router();

const libs = `${process.cwd()}/libs`;

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const reqBody = require(`${libs}/middlewares/reqBody`);

const config = require(`${libs}/config`); 

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

let rqf = new ReqQueryFields();

const id2str = require(`${libs}/middlewares/id2str`);

simcaqTeacherCityPlanApp.use(cache('15 day'));

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'year',
    table: 'simcaq_docente_municipio_plano',
    tableField: 'ano_censo',
    where: {
        relation: '=',
        type: 'integer',
        field: 'ano_censo'
    }
}).addValue({
    name: 'city',
    table: 'municipio',
    tableField: ['nome', 'id'],
    resultField: ['city_name', 'city_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'escola_municipio_id',
        foreignTable: 'simcaq_docente_municipio_plano'
    }
}, 'dims').addValue({
    name: 'state',
    table: 'estado',
    tableField: ['nome', 'id'],
    resultField: ['state_name', 'state_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'escola_estado_id',
        foreignTable: 'simcaq_docente_municipio_plano'
    }
}, 'dims').addValue({
    name: 'school',
    table: 'escola_agregada',
    tableField: ['nome', 'id'],
    resultField: ['school_name', 'school_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'escola_id',
        foreignTable: 'simcaq_docente_municipio_plano'
    }
}, 'dims').addValue({
    name: 'country',
    table: 'simcaq_docente_municipio_plano',
    tableField: ['escola_pais_nome', 'escola_pais_id'],
    resultField: ['country_name', 'country_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'escola_pais_id'
    }
}).addValue({
    name: 'adm_dependency_id',
    table: 'simcaq_docente_municipio_plano',
    tableField: 'dependencia_adm_id',
    resultField: 'adm_dependency_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'dependencia_adm_id'
    }
});

simcaqTeacherCityPlanApp.get('/', rqf.parse(), rqf.build(), (req, res, next) => {
    req.sql.from('simcaq_docente_municipio_plano')
        .field('simcaq_docente_municipio_plano.num_docentes', 'num_teachers')
        .field('simcaq_docente_municipio_plano.dependencia_adm_id', 'adm_dependency_id')
        .field('simcaq_docente_municipio_plano.ano_censo', 'year');
    next();
}, query, id2str.transform(), response('simcaqTeacherCityPlan'));

module.exports = simcaqTeacherCityPlanApp;
