const express = require('express');

const simulationApp = express();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const Simulation = require(`${libs}/models/simulation`);

const PQR = require(`${libs}/models/pqr`);

const passport = require('passport');

simulationApp.get('/time', (req, res, next) => {
    const maxTime = parseInt(req.query.max_time, 10);
    if(isNaN(maxTime)) {
        res.status(400);
        next({
            status: 400,
            message: 'Invalid value for mandatory parameter max_time'
        });
    }
    res.json({
        result: Array.apply(null, {length: maxTime}).map(Number.call, Number).map((i)=>i+1)
    });
});

simulationApp.get('/pqr', (req, res) => {
    PQR.findOne((err, pqr) => {
        if(err) {
            log.error(err);
            return next({err});
        }

        res.json(pqr);
    });
});

simulationApp.put('/pqr', passport.authenticate('bearer', { session: false }), (req, res, next) => {
    let user = req.user.toObject();

    PQR.findOne((err, pqr) => {
        if(err) {
            log.error(err)
            return next({err});
        }

        if(!user.admin) {
            log.info(`Usuário ${user.email} tentou alterar o PQR, mas não tem privilégio`);
            res.statusCode = 401;
            return next({err: { msg: 'Unauthorized'}});
        }
        pqr.content = req.body.content || pqr.content;
        pqr.save((err) => {
            if(err) {
                log.error(err);
                return next({err});
            }
            res.json({msg: 'PQR updated'})
        });
    });
});

simulationApp.get('/', passport.authenticate('bearer', { session: false }), (req, res) => {
    let user = req.user.toObject();
    let query = Simulation.find({userId: user._id}).select('userId name createdAt updatedAt');
    query.exec((err, simulations) => {
        if(err) {
            log.error(err);
            return next({err});
        }

        res.json(simulations);
    });

    // Simulation.find({userId: user._id}, (err, simulations) => {
    //     if(err) {
    //         log.error(err);
    //         return next({err});
    //     }

    //     res.json(simulations);
    // });
});

simulationApp.post('/', passport.authenticate('bearer', { session: false }), (req, res, next) => {
    let user = req.user.toObject();

    let simulation = new Simulation({
        userId: user._id,
        content: req.body.content,
        name: req.body.name
    });

    simulation.save((err) => {
        if(err) {
            log.error(err);
            return next({err});
        }

        res.json({msg: 'Simulation created', simulation});
    })
});

simulationApp.get('/:id', passport.authenticate('bearer', { session: false }), (req, res) => {
    let user = req.user.toObject();

    Simulation.findOne({_id: req.params.id, userId: user._id}, (err, simulation) => {
        if(err) {
            log.error(err);
            return next({err});
        }

        res.json(simulation);
    });
});

simulationApp.put('/:id', passport.authenticate('bearer', { session: false }), (req, res, next) => {
    let user = req.user.toObject();

    Simulation.findOne({_id: req.params.id, userId: user._id}, (err, simulation) => {
        if(err) {
            log.error(err);
            return next({err});
        }

        if(!simulation) {
            res.statusCode = 404;
            return next({err: { msg: 'Simulation not found'}});
        }

        simulation.content = req.body.content || simulation.content;
        simulation.name = req.body.name || simulation.name;
        simulation.updatedAt = Date.now();

        simulation.save((err) => {
            if(err) {
                log.error(err);
                return next(err);
            }

            res.json(simulation);
        });
    });
});

simulationApp.delete('/:id', passport.authenticate('bearer', { session: false }), (req, res, next) => {
    let user = req.user.toObject();

    Simulation.remove({_id: req.params.id, userId: user._id}, (err, simulation) => {
        if(err) {
            log.error(err);
            return next({err});
        }

        res.json({msg: 'Simulation removed'});
    });
});

module.exports = simulationApp;
