const express = require('express');

const userApp = express();

const libs = `${process.cwd()}/libs`;

const config = require(`${libs}/config`);

const log = require(`${libs}/log`)(module);

const User = require(`${libs}/models/user`);

const VerificationToken = require(`${libs}/models/verificationToken`);

const ResetToken = require(`${libs}/models/resetToken`);

const response = require(`${libs}/middlewares/response`);

const email = require(`${libs}/middlewares/email`);

const passport = require('passport');

function emailSyntax(email) {
  const regex = /^(([^<>()\[\]\.,;:\s@\"]+(\.[^<>()\[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i;
  return regex.test(email);
}

userApp.get('/schooling', (req, res, next) => {
  req.result = [
    'Não estudou',
    'Ensino Fundamental Incompleto',
    'Ensino Fundamental Completo',
    'Ensino Médio',
    'Graduação',
    'Mestrado',
    'Doutorado'
  ];
  next();
}, response('schooling'));

userApp.get('/segment', (req, res, next) => {
  req.result = [
    'Gestores e equipe gestora das secretarias e ministério da Educação',
    'Gestores dos órgãos de planejamento e finanças (das três esferas de governo)',
    'Agentes do poder legislativo',
    'Agentes dos conselhos de educação',
    'Profissionais da educação',
    'Sindicato',
    'Sociedade civil interessada no financiamento da Educação Básica de qualidade',
    'Comunidade acadêmica',
    'Imprensa',
    'Outro [citar segmento]'
  ];
  next();
}, response('segment'));

userApp.get('/role', (req, res, next) => {
  req.result = [
    {"Gestores e equipe gestora das secretarias e ministério da Educação" : ["Dirigente municipal, estadual e federal", "Secretário do MEC", "Servidor da área de planejamento educacional", "Membro de associação de gestores (Ex. Undime, Consed, etc)", "Outro [citar função]"]},
    {"Gestores dos órgãos de planejamento e finanças (das três esferas de governo)" : ["Equipe gestora dos órgãos de planejamento", "Equipe gestora dos órgãos de finanças", "Outro [citar função]"]},
    {"Agentes do poder legislativo" : ["Parlamentar", "Assessor/a parlamentar", "Auditor/a dos tribunais de conta", "Conselheiro/a de tribunais de conta.", "Outro [citar função]"]},
    {"Agentes dos conselhos de educação" : ["Conselheiro/a municipais, estaduais e federais", "Conselheiro/a do Fundeb", "Outro [citar função]"]},
    {"Profissionais da educação" : ["Professor/a da Educação Básica", "Profissional da educação não-docente", "Outro [citar função]"]},
    {"Sindicato" : ["Agente de sindicatos"]},
    {"Sociedade civil interessada no financiamento da Educação Básica de qualidade" : ["Membro de fóruns educacionais", "Membro de ONGs e demais entidades sem fins lucrativos", "Estudante da educação básica e membro de entidades estudantis", "Pais e membros de entidades de pais", "Outro [citar função]"]},
    {"Comunidade acadêmica" : ["Pesquisador/a", "Estudantes de graduação e pós-graduação", "Representantes de entidades de pesquisa (Ex.: ANPED, ANPAE e FINEDUCA)", "Outro [citar função]"]},
    {"Imprensa" : ["Jornalista", "Outro [citar função]"]},
    {"Outro [citar segmento]" : []}
  ]
  next();
}, response('role'));

/*
userApp.get('/', passport.authenticate('bearer', {session: false}), (req, res, next) => {
  User.find((err, users) => {
    if(err) {
      log.error(err);
      return next(err);
    }

    let result = [];
    users.forEach((user) => {
      let u = user.toObject();
      delete u.hashedPassword;
      delete u.salt;
      result.push(u);
    });
    req.result = result;
    next();
  });
}, response('users'));
*/

userApp.get('/me', passport.authenticate('bearer', { session: false }), (req, res, next) => {
  let user = req.user.toObject();
  delete user.hashedPassword;
  delete user.salt;
  req.result = user;
  next();
}, response('user'));

userApp.get('/:id', (req, res, next) => {
  User.findOne({id:req.params.id}, (err, user) => {
    if(err) {
      log.error(err);
      return next(err);
    }
    if(!user) {
      req.statusCode = 404;
      next({msg: 'User not found'});
    } else {
      let u = user.toObject;
      delete u.hashedPassword;
      delete u.salt;
      req.result = u;
      next();
    }
  });
}, response('user'));

userApp.post('/', (req, res, next) => {
  let user = new User({
    email: req.body.email,
    password: req.body.password,
    name: req.body.name,
    nickname: req.body.nickname,
    cpf: req.body.cpf,
    cep: req.body.cep,
    complement: req.body.complement,
    address: req.body.address,
    phone: req.body.phone,
    schooling: req.body.schooling,
    course: req.body.course,
    segment: req.body.segment,
    role: req.body.role,
    institutionName: req.body.institutionName,
    state: req.body.state,
    city: req.body.city,
    receiveEmails: false || req.body.receiveEmails,
    origin: req.body.origin,
    citesegment: req.body.citesegment,
    citerole: req.body.citerole,
    admin: false
  });

  if (typeof req.body.password === 'undefined' || !req.body.password) {
    res.statusCode = 400;
    return res.json({errors: ["O campo senha é obrigatório"]});
  } else {
    user.save((err) => {
      if(err) {
        log.error(err);
        let errors = [];
        for(let errName in err.errors) {
          errors.push(err.errors[errName].message);
        }
        log.error(errors);
        res.statusCode = 400;
        return res.json({err, errors});
      }

      // Create verification token
      let verificationToken = new VerificationToken({
        userId: user._id
      });

      verificationToken.createVerificationToken((err, token) => {
        if(err) {
          log.error(err);
          return next(err);
        }
        let url = config.default.lde.url + '/verify';
        let text = `Olá, ${user.name}, seja bem vindo/a ao Laboratório de Dados Educacionais.\n\nClique neste link para confirmar sua conta: ${url}/${token}`;
        // Send confirmation email
        let mailOptions = {
          to: `"${user.name} <${user.email}>"`,
          subject: "Confirme seu cadastro - Laboratório de Dados Educacionais",
          text
        }
        email(mailOptions, (err, info) => {
          if(err) {
            log.error(err);
            res.json({msg: 'User created'});
          }
          if(info) {
            log.info(`Message ${info.messageId} sent: ${info.response}`);
            log.info(`Usuário ${user.email} foi criado`);
          }
          res.json({msg: 'User created'});
        });
      });
    });
  }

});

userApp.put('/:id', passport.authenticate('bearer', { session: false }), (req, res, next) => {
  User.findOne({id:req.params.id}, (err, user) => {
    if (err) {
      log.error(err);
      return next({err});
    }

    if(!user) {
      res.statusCode = 404;
      return next({err: {
        message: 'Usuário não encontrado'
      }});
    }

    user.email = req.body.email || user.email;
    user.name = req.body.name || user.name;
    user.nickname = req.body.nickname || user.nickname || user.name;
    user.cep = req.body.cep || user.cep;
    user.complement = req.body.complement || user.complement;
    user.address = req.body.address || user.address;
    user.phone = req.body.phone || user.phone;
    user.schooling = req.body.schooling || user.schooling;
    user.course = req.body.course || user.course;
    user.segment = req.body.segment || user.segment;
    user.role = req.body.role || user.role;
    user.institutionName = req.body.institutionName || user.institutionName;
    user.state = req.body.state || user.state;
    user.city = req.body.city || user.city;
    user.receiveEmails = req.body.receiveEmails || user.receiveEmails;
    user.citesegment = req.body.citesegment || user.citesegment;
    user.citerole = req.body.citerole || user.citerole;

    if ((req.body.password) && (req.body.newpassword)) {
        if (req.body.password != req.body.newpassword) {
            if (user.checkPassword(req.body.password)) {
                user.password = req.body.newpassword;
            } else {
                res.statusCode = 500;
                return res.json({error: {
                    message: 'A senha atual está incorreta'
                }});
            }
        } else {
            res.statusCode = 500;
            return res.json({error: {
                message: 'A nova senha é a mesma da senha atual'
            }});
        }
    }

    user.save(err => {
      if(err) {
        log.error(err);
        return next({message: 'Erro ao atualizar usuário'});
      }
      let u = user.toObject();
      delete u.hashedPassword;
      delete u.salt;
      res.json({user: u});
    })
  })
});

userApp.get('/reset/password', (req, res, next) => {
  let emailAddress = req.query.email;
  User.findOne({email: emailAddress}, (err, user)=> {
    if(err) {
      log.error(err);
      let errors = [];
      for(let errName in err.errors) {
        errors.push(err.errors[errName].message);
      }
      res.statusCode = 400;
      return res.json({err, errors});
    }
    if (!user) {
      res.statusCode = 404;
      res.json({msg: "O usuário não está cadastrado"});
    }
    else {
      let resetToken = new ResetToken({
        userId: user._id
      });
      resetToken.createResetToken((err, token) => {
        if (err) {
          log.error(err);
          return next(err);
        }
        let url = config.default.lde.url + '/reset-password';
        let text = `Olá, ${user.name}.\n\nRecebemos uma solicitação para redefinir sua senha do Laboratório de Dados Educacionais. Clique neste link para redefinir a sua senha: ${url}/${token}`;
        let mailOptions = {
          to: `"${user.name} <${user.email}>"`,
          subject: "Redefinição de Senha - Laboratório de Dados Educacionais",
          text
        }
        email(mailOptions, (err, info) => {
          if(err) {
            log.error(err);
            res.json({msg: 'Undelivered Reset Password Mail'});
          }
          log.info(`Message ${info.messageId} sent: ${info.response}`);
          res.json({msg: 'Reset Password Mail Successfully Delivered'});
        });
      })
    }
  })
})

module.exports = userApp;
