const id2str = require(`./id2str`);

/*
    Middleware que tem como função formatar dados agregados.
    Dados agregados não podem ser 'puxados' do banco de dados da mesma maneira que os dados tradicioanis, dessa maneira é
    necessário formatá-los para que sigam o padrão.
*/

// Faz o mapeamento dos filtros com seus respectivos 'id2str'
const convert = {
    adm_dependency_detailed: 'admDependencyPriv',
    location: 'location',
    diff_location: 'diffLocation',
    region: 'regionCode',
    state: 'stateName',
    age_range: 'ageRangeAggregate',
    gender: 'gender',
    ethnic_group: 'ethnicGroup',
    education_level_mod_agg: 'educationLevelModAgg',
    integral_time_agg: 'integralTime',
    period_agg: 'period',
    modality_integral_time: 'educationLevelBasic',
    special_education: 'specialEducation',
    special_education_doc: 'specialEducationDoc',
    special_education_entity: 'specialEducationEntity',
    education_level_mod_doc: 'educationLevelModDoc',
    education_level_mod_entity_seg: 'educationLevelModEntitySeg',
    education_level_mod_entity_agg: 'educationLevelModEntityAgg',
    adm_dependency_entity_agg: 'newPnadAdmDependency',
    adm_dependency_entity: 'admDependency',
    location_entity: 'location',
    gender_entity: 'gender',
    age_range_entity: 'ageRangeEntity',
    post_graduation_entity: 'postGraduationEntity',
    contract_type_entity: 'contractType',
    total_doc: "totalDoc",
    education_degree_entity: "educationDegreeEntity",
    government_agreement: "governmentAgreement"
}

function aggregateData(req, res, next) {
    if (req.query.dims) {
        const newResult = []
        const aggregateFields = [
            'gender', 
            'age_range', 
            'ethnic_group', 
            'education_level_mod_agg',
            'education_level_mod_doc',
            'integral_time_agg', 
            'period_agg', 
            'modality_integral_time', 
            'special_education',
            'special_education_doc',
            'special_education_entity',
            'education_level_mod_entity_seg',
            'education_level_mod_entity_agg',
            'adm_dependency_entity_agg',
            'adm_dependency_entity',
            'location_entity',
            'gender_entity',
            'age_range_entity',
            'post_graduation_entity',
            'contract_type_entity',
            'education_degree_entity'
        ]
        let id;
        const fields = req.query.dims.split(',');
        let currentAggregateField;
        let currentNonAggregateField;
    
        // Verifica se o filtro passado está presente nos filtros agregados
        fields.forEach(field => {if (aggregateFields.includes(field)) currentAggregateField = field; else currentNonAggregateField = field});
        if (currentAggregateField) {
            req.result.forEach((r) => {
                // Alguns filtros começam com o id = 0 outros id = 1
                id = ['ethnic_group', 'integral_time_agg'].includes(currentAggregateField) ? 0 : 1;
                for (const property in r) {
                    // Dados agregados são identificados com a substring 'total_' em sua chave
                    if (property.includes('total_')) {
                        let data = {
                            total: r[property],
                            year: r.year,
                            [`${currentAggregateField}_id`]: id,
                            [`${currentAggregateField}_name`]: id2str[convert[currentAggregateField]](id)
                        }
        
                        if (currentNonAggregateField) {
                            data[`${currentNonAggregateField}_id`] = r[`${currentNonAggregateField}_id`];
                            data[`${currentNonAggregateField}_name`] = id2str[convert[currentNonAggregateField]](r[`${currentNonAggregateField}_id`]);
                        }
        
                        newResult.push(data)
                        ++id;
                    }
                }
            })
            req.result = newResult;
        }
    }
    next();
}

module.exports = aggregateData;