const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const execute = require(`${libs}/middlewares/query`).execute;

const request = require(`request`);

const config = require(`${libs}/config`);

const Download = require(`${libs}/models/download`);

module.exports = function download(table, mapping_table) {
    return (req, res, next) => {
        // First, query the mapping
        execute(`SELECT target_name, name FROM ${mapping_table}`, undefined, (err, result) => {
            if (err) {
                log.error(err.stack);
                next(new Error('Request could not be satisfied due to a database error.'));
            } else {
                let header = '';
                req.sql.from(table);
                result.forEach((field) => {
                    req.sql.field(`CASE ${table}.${field.name} WHEN true THEN 1 WHEN false THEN 0 ELSE ${table}.${field.name} END AS ${field.target_name}`);
                    // req.sql.field(table + '.' + field.name, field.target_name);
                    if (header === '') header += field.target_name;
                    else header = header + ';' + field.target_name;
                });

                let form = {
                    query: req.sql.toString(),
                    table: req.sql.tableFrom,
                    name: req.sql.tableFrom,
                    username: req.user.name,
                    email: req.user.email,
                    header
                };

                request.post(config.cdn.url + '/api/v1/file', { form }, async (err, response, body) => {
                    if (err) {
                        log.error(err);
                        return res.json({ error: err });
                    }

                    let download = await Download.findOne({ where: { query: req.sql.toString() } }).catch(function (err) {
                        if (err) {
                            log.error(err);
                        }
                    })
                    if (download) {
                        download.updated_at = new Date();
                        if (download.user_id != req.user.id) {
                            let dl = await Download.create({
                                user_id: req.user.id,
                                table,
                                name: req.query.name,
                                mapping_table,
                                query: req.sql.toString(),
                                status: 'Enviando',
                                expired: false
                            });
                            console.log(dl);
                            dl.save().catch(function (err) {
                                if (err) log.error(err);
                            });
                        }
                    } else {
                        download = await Download.create({
                            user_id: req.user.id,
                            table,
                            name: req.query.name,
                            mapping_table,
                            query: req.sql.toString(),
                            status: 'Enviando',
                            expired: false
                        });
                        console.log(download);
                    }

                    await download.save()
                    res.json({ msg: 'Wait for download email', waitForIt: true });
                });
            };
        });
    }
}