const libs = `${process.cwd()}/libs`;
const log = require(`${libs}/log`)(module);
const config = require(`${libs}/config`);
const nodemailer = require('nodemailer');
const htmlToText = require('nodemailer-html-to-text').htmlToText;

let transporter = nodemailer.createTransport({
    host: config.email.host,
    port: config.email.port,
    secureConnection: config.email.secureConnection,
    auth: config.email.auth,
    tls: config.email.tls,
});

transporter.use('compile', htmlToText());

// verify connection configuration
transporter.verify(function(error, success) {
   if (error) {
        log.error(error);
   } else {
        log.info('Email server is ready to take our messages');
   }
});

const mailOptions = {
    from: config.email.from,
    to: config.email.from
};

module.exports = function send(options, cb) {
    let opt = Object.assign({}, mailOptions, options);
    transporter.sendMail(opt, (err, info) => {
        if(err) {
	    console.log("Erro email");
            return cb(err);
        }
	console.log("OK email");
        cb(null, info);
    });
};
