const oauth2orize = require('oauth2orize');
const passport = require('passport');
const crypto = require('crypto');

const libs = `${process.cwd()}/libs`;

const config = require(`${libs}/config`);
const log = require(`${libs}/log`)(module);

const User = require(`${libs}/models/user`);
const AccessToken = require(`${libs}/models/accessToken`);
const RefreshToken = require(`${libs}/models/refreshToken`);

const origin_to_secret = {
    'SimCAQ': 'FcmZp9bZpk8yxSJA',
    'LDE': 'LDE'
};

// create OAuth 2.0 server
let aserver = oauth2orize.createServer()

// Generic error handler
let errFn = (cb, err) => {
    if (err) {
        return cb(err)
    }
}

// Destroys any old tokens and generates a new access and refresh token
let generateTokens = (userId, clientId,userRole, done) => {
    // curries in `done` callback so we don't need to pass it
    let refreshTokenValue;
    let tokenValue;
    let admin = false; 

    RefreshToken.destroy({where:{"user_id": userId, "client_id": clientId}});
    AccessToken.destroy({where:{"user_id": userId, "client_id": clientId}});

    tokenValue = crypto.randomBytes(32).toString('hex');
    refreshTokenValue = crypto.randomBytes(32).toString('hex');

    AccessToken.create({
        user_id:userId, 
        client_id:clientId,
        token:tokenValue
    })

    let refreshed_token = refreshTokenValue;

    RefreshToken.create({
        user_id:userId, 
        client_id:clientId,
        token:refreshed_token
    })
    if(userRole == 1){
        admin = true;
    }
    done(null, tokenValue, refreshTokenValue, {'admin': admin},{
        'expires_in': config.security.tokenLife
    });

};


// Exchange username & password for access token.
aserver.exchange(oauth2orize.exchange.password(function(client, username, password, scope, done) {
    User.findOne({ 
      where: {email:username} 
    }).then(function(user) {
      if(user == null|| !user.checkPassword(user, password)){
        return done(null, false);
      }

      if(origin_to_secret[user.dataValues.origin] != client.client_secret){
        console.log(origin_to_secret[user.dataValues.origin]);
	console.log("Erro de client_secret");
        //return done(null, false);
      }
      log.info(`Gerando token para usuário ${user.name}`);
      generateTokens(user.dataValues.id, client.id, user.dataValues.role_id, done);
    }).catch(function(error) {
      return done(error);
    });
  }));


// Exchange refreshToken for access token.
aserver.exchange(oauth2orize.exchange.refreshToken((client, refreshToken, scope, done)  =>{
    RefreshToken.findOne({where: {token: refreshToken, client_id: client.id }}).then(function(token){
        if (!token) {
            return done(null, false);
        }
        User.findByPk(token.user_id).then(function(user){
            if (!user) { 
                return done(null, false); 
            }
            generateTokens(user.id, client.id, done);
        })
    })
}))

// token endpoint
//
// `token` middleware handles client requests to exchange authorization grants
// for access tokens.  Based on the grant type being exchanged, the above
// exchange middleware will be invoked to handle the request.  Clients must
// authenticate when making requests to this endpoint.


// ,function(err, user) {
//     if (err) { console.log("Erro de autenticação"); }
//     if (!user) { console.log("Erro de usuario ausente");}
// }

exports.token = [
    passport.authenticate(['oauth2-client-password'], { session: false }),
    aserver.token(),
    aserver.errorHandler()
];
