const Sequelize = require("sequelize");
const db = require('../db/postgres.js');
const libs = `${process.cwd()}/libs`;

var Publication = db.define("Publication",{
    id:{
        type: Sequelize.STRING,
        allowNull:false,
        unique: true,
        primaryKey: true
    },
    filter:{
        type: Sequelize.ENUM("Artigo", "Tese", "Dissertação", "Relatório", "Periódico"),
        allowNull:false,
        validate: {
            notNull: { msg: "O campo categoria é obrigatória e aceita apenas os valores 'Artigo', 'Tese', 'Dissertação', 'Relatório', 'Periódico."},
            isIn:{
                args: [["Artigo", "Tese", "Dissertação", "Relatório", "Periódico"]],
                msg: "O campo categoria é obrigatória e aceita apenas os valores 'Artigo', 'Tese', 'Dissertação', 'Relatório', 'Periódico'."
            }
        }
    },
    title:{
        type: Sequelize.STRING,
        allowNull:false,
    },
    authors:{
        type: Sequelize.STRING,
        allowNull:false
    },
    organization:{
        type: Sequelize.STRING,
        allowNull:false
    },
    year:{
        type:Sequelize.STRING,
        allowNull:false
    },
    text:{ 
        type: Sequelize.ENUM("Baixar","Acessar"),
        allowNull:false,
        validate: {
            notNull: { msg: "O campo origem é obrigatória e aceita apenas os valores 'Baixar', 'Acessar'."},
            isIn:{
                args: [["Baixar", "Acessar"]],
                msg: "O campo origem é obrigatória e aceita apenas os valores 'Baixar', 'Acessar'."}
        }
    },
    link:{
        type: Sequelize.STRING
    },
    upload:{
        type: Sequelize.STRING
    },
    is_draft:{
        type:Sequelize.BOOLEAN,
        allowNull:false,
        defaultValue: true
    },
    is_headline:{
        type:Sequelize.BOOLEAN,
        allowNull: false,
        defaultValue: false
    },
    volume:{
        type:Sequelize.STRING
    },
    pages:{
        type:Sequelize.STRING
    }
},{timestamp:true,
  createdAt: 'created_at',
  updatedAt: 'updated_at'}
);

Publication.generateObjectId = function(){
    var timestamp = (new Date().getTime() / 1000 | 0).toString(16);
    return timestamp + 'xxxxxxxxxxxxxxxx'.replace(/[x]/g, function() {
        return (Math.random() * 16 | 0).toString(16);
    }).toLowerCase();
}

const setObjectId = pb => {
   pb.id = Publication.generateObjectId()
};

Publication.beforeCreate(setObjectId);

module.exports = Publication;