const Sequelize = require("sequelize");
const libs = `${process.cwd()}/libs`;
const db = require('../db/postgres.js');
const User = require(`${libs}/models/user`);
const Client = require(`${libs}/models/client`);

var RefreshToken = db.define("RefreshToken",{
    user_id: {
        type: Sequelize.STRING,
        allowNull: false
    },
    client_id:{
        type: Sequelize.STRING,
        allowNull: false
    },
    token:{
        type: Sequelize.STRING, 
        allowNull: false,
        unique: true,
        primaryKey: true
    },
    created_at:{
        type: Sequelize.DATE,
        defaultValue: Date.now
    }},
    {timestamps: false}
);

RefreshToken.hasOne(User, { foreignKey: 'id' });
RefreshToken.hasOne(Client, { foreignKey: 'id' });

module.exports = RefreshToken;

