/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');
const { result } = require('lodash');

const enrollmentAggregateApp = express.Router();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const aggregateData = require(`${libs}/middlewares/aggregateData`);

const id2str = require(`${libs}/middlewares/id2str`);

const config = require(`${libs}/config`);

const addMissing = require(`${libs}/middlewares/addMissing`);

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

enrollmentAggregateApp.use(cache('15 day'));

let rqf = new ReqQueryFields();

enrollmentAggregateApp.get('/years', (req, res, next) => {
    req.sql.from('escola')
    .field('DISTINCT escola.ano_censo', 'year')
    .where('escola.ano_censo >= 2021')
    next();
}, query, response('years'));

enrollmentAggregateApp.get('/adm_dependency', (req, res, next) => {
    req.result = []

    for (let i = 1; i <= 5; i++) {
        req.result.push({
            id: i, name: id2str.admDependency(i)
        });
    }
    next();
}, response('adm_dependency'));

enrollmentAggregateApp.get('/adm_dependency_detailed', (req, res, next) => {
    req.result = []

    for (let i = 1; i <= 8; i++) {
        req.result.push({
            id: i, name: id2str.admDependencyPriv(i)
        });
    }
    next();
}, response('adm_dependency_detailed'));

enrollmentAggregateApp.get('/government_agreement', (req, res, next) => {
    req.result = []
    
    for(let i = 1; i <= 6; ++i) {
        req.result.push({
            id: i,
            name: id2str.governmentAgreement(i)
        });
    };
    next();
}, response('government_agreement'));

enrollmentAggregateApp.get('/education_level_mod_agg', (req, res, next) => {
    req.result = []

    for (let i = 1; i <= 13; i++) {
        req.result.push({
            id: i, name: id2str.educationLevelMod(i)
        });
    }
    next();
}, response('education_level_mod_agg'));

enrollmentAggregateApp.get('/integral_time_agg', (req, res, next) => {
    req.result = []

    for (let i = 0; i <= 3; i++) {
        req.result.push({
            id: i, name: id2str.integralTime(i)
        });
    }
    next();
}, response('integral_time_agg')); 

enrollmentAggregateApp.get('/location', (req, res, next) => {
    req.result = []

    for (let i = 1; i <= 2; i++) {
        req.result.push({
            id: i, name: id2str.location(i)
        });
    }
    next();
}, response('location'));

enrollmentAggregateApp.get('/diff_location', (req, res, next) => {
    req.result = []

    for (let i = 0; i < 4; i++) {
        req.result.push({
            id: i, name: id2str.diffLocation(i)
        });
    }

    req.result.push({
        id: 8, name: 'Área onde se localizam povos e comunidades tradicionais'
    })

    next();
}, response('diff_location'));

enrollmentAggregateApp.get('/modality_integral_time', (req, res, next) => {
    req.result = []

    for (let i = 0; i <= 7; i++) {
        req.result.push({
            id: i, name: id2str.educationLevelBasic(i)
        });
    }

    next();
}, response('modality_integral_time'));

enrollmentAggregateApp.get('/gender', (req, res, next) => {
    req.result = []

    for (let i = 1; i <= 2; i++) {
        req.result.push({
            id: i, name: id2str.gender(i)
        });
    }

    next();
}, response('gender'));

enrollmentAggregateApp.get('/age_range', (req, res, next) => {
    req.result = []

    for (let i = 1; i <= 7; i++) {
        req.result.push({
            id: i, name: id2str.ageRangeAggregate(i)
        });
    }

    next();
}, response('age_range'));

enrollmentAggregateApp.get('/ethnic_group', (req, res, next) => {
    req.result = []

    for (let i = 0; i <= 6; i++) {
        req.result.push({
            id: i, name: id2str.ethnicGroup(i)
        });
    }

    next();
}, response('ethnic_group'));

enrollmentAggregateApp.get('/period_agg', (req, res, next) => {
    req.result = []

    for (let i = 0; i <= 5; i++) {
        req.result.push({
            id: i, name: id2str.period(i)
        });
    }

    next();
}, response('period_agg'));

enrollmentAggregateApp.get('/region', (req, res, next) => {
    req.result = []

    for (let i = 0; i <= 5; i++) {
        req.result.push({
            id: i, name: id2str.regionCode(i)
        });
    }

    next();
}, response('period_agg'));

enrollmentAggregateApp.get('/state', (req, res, next) => {
    req.result = []
    for (let i = 11; i < 54; i++) {
        if (id2str.stateName(i) !== 'Não declarada') {
            req.result.push({
                id: i, name: id2str.stateName(i)
            });
        }
    }

    next();
}, response('state'));

enrollmentAggregateApp.get('/special_education', (req, res, next) => {
    req.result = []

    for (let i = 1; i <= 2; i++) {
        req.result.push({
            id: i, name: id2str.specialEducation(i)
        });
    }

    next();
}, response('special_education'));


rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'adm_dependency',
    table: 'escola',
    tableField: 'dependencia_adm_id',
    resultField: 'adm_dependency_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'dependencia_adm_id'
    }
}).addValue({
    name: 'adm_dependency_detailed',
    table: 'escola',
    tableField: 'dependencia_adm_priv',
    resultField: 'adm_dependency_detailed_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'dependencia_adm_priv'
    }
}).addValue({
    name: 'education_level_mod',
    table: 'escola',
    tableField: 'etapas_mod_ensino_segmento_id',
    resultField: 'education_level_mod_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'etapas_mod_ensino_segmento_id'
    }
}).addValue({
    name:'integral_time',
    table: 'escola',
    tableField: 'tempo_integral',
    resultField: 'integral_time_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'tempo_integral'
    }
  }).addValue({
    name: 'education_level_short',
    table: 'escola',
    tableField: 'etapa_resumida',
    resultField: 'education_level_short_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'etapa_resumida'
    }
}).addValue({
    name: 'region',
    table: 'regiao',
    tableField: ['nome', 'id'],
    resultField: ['region_name', 'region_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'regiao_id',
        foreignTable: 'escola'
    }
}).addValue({
    name: 'mesoregion',
    table: 'municipio',
    tableField: ['nome_mesorregiao', 'mesorregiao_id'],
    resultField: ['mesoregion_name', 'mesoregion_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'mesorregiao_id',
        table: 'municipio'
    },
    join: {
        primary: 'id',
        foreign: 'municipio_id',
        foreignTable: 'escola'
    }
}).addValue({
    name: 'microregion',
    table: 'municipio',
    tableField: ['nome_microrregiao', 'microrregiao_id'],
    resultField: ['microregion_name', 'microregion_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'microrregiao_id',
        table: 'municipio'
    },
    join: {
        primary: 'id',
        foreign: 'municipio_id',
        foreignTable: 'escola'
    }
}).addValue({
    name: 'min_year',
    table: 'escola',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '>=',
        type: 'integer',
        field: 'ano_censo',
    },
}).addValue({
    name: 'max_year',
    table: 'escola',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '<=',
        type: 'integer',
        field: 'ano_censo',
    },
}).addValueToField({
    name: 'state',
    table: 'estado',
    tableField: ['nome', 'id'],
    resultField: ['state_name', 'state_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'estado_id',
        foreignTable: 'escola'
    }
}, 'dims').addValueToField({
    name: 'state',
    table: 'estado',
    tableField: 'nome',
    resultField: 'state_name',
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'estado_id',
        foreignTable: 'escola'
    }
}, 'filter').addValueToField({
    name: 'city',
    table: 'municipio',
    tableField: ['nome', 'id'],
    resultField: ['city_name', 'city_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'municipio_id',
        foreignTable: 'escola'
    }
}, 'dims').addValueToField({
    name: 'city',
    table: 'municipio',
    tableField: 'nome',
    resultField: 'city_name',
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'municipio_id',
        foreignTable: 'escola'
    }
}, 'filter').addValueToField({
    name: 'school',
    table: 'escola',
    tableField: ['nome_escola', 'id'],
    resultField: ['school_name', 'school_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: ['id', 'ano_censo'],
        foreign: ['escola_id', 'ano_censo'],
        foreignTable: 'escola'
    }
}, 'dims').addValueToField({
    name: 'locale_id',
    table: 'escola',
    tableField: 'localizacao_id',
    resultField: 'locale_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'localizacao_id'
    }
}, 'dims').addValueToField({
    name: 'school_id',
    table: 'escola',
    tableField: 'id',
    resultField: 'school_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: ['id', 'ano_censo'],
        foreign: ['escola_id', 'ano_censo'],
        foreignTable: 'escola'
    }
}, 'dims').addValueToField({
    name: 'school',
    table: 'escola',
    tableField: 'nome_escola',
    resultField: 'school_name',
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: ['id', 'ano_censo'],
        foreign: ['escola_id', 'ano_censo'],
        foreignTable: 'escola'
    }
}, 'filter').addValue({
    name: 'location',
    table: 'escola',
    tableField: 'localizacao_id',
    resultField: 'location_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'localizacao_id'
    }
}).addValue({
    name: 'diff_location',
    table: 'escola',
    tableField: 'localizacao_diferenciada_par',
    resultField: 'diff_location_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'localizacao_diferenciada_par',
    }
}).addValue({
    name: 'government_agreement',
    table: 'escola',
    tableField: 'dependencia_convenio_publico',
    resultField: 'government_agreement_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'dependencia_convenio_publico'
    }
});

// Return all cities
enrollmentAggregateApp.get('/', rqf.parse(), rqf.build(), (req, res, next) => {

    console.log(req.query);

    if (req.query.dims && req.query.dims.includes('gender'))
    {
        req.sql.from('escola')
        .field('SUM(escola.qt_mat_bas_masc)', 'total_mas')
        .field('SUM(escola.qt_mat_bas_fem)', 'total_fem')
        .field('escola.ano_censo', 'year')
        .group('escola.ano_censo')
        .order('escola.ano_censo')
        .where('escola.localizacao_diferenciada_par is not null');
    }
    else if (req.query.dims && req.query.dims.includes('age_range')) {
        req.sql.from('escola')
        .field('SUM(escola.qt_mat_bas_0_3)', 'total_0_3')
        .field('SUM(escola.qt_mat_bas_4_5)', 'total_4_5')
        .field('SUM(escola.qt_mat_bas_6_10)', 'total_6_10')
        .field('SUM(escola.qt_mat_bas_11_14)', 'total_11_14')
        .field('SUM(escola.qt_mat_bas_15_17)', 'total_15_17')
        .field('SUM(escola.qt_mat_bas_18_mais)', 'total_18_mais')
        .field('escola.ano_censo', 'year')
        .group('escola.ano_censo')
        .order('escola.ano_censo')
        .where('escola.localizacao_diferenciada_par is not null')
    }
    else if (req.query.dims && req.query.dims.includes('ethnic_group')) {
        req.sql.from('escola')
        .field('SUM(escola.qt_mat_bas_nd)', 'total_nd')
        .field('SUM(escola.qt_mat_bas_branca)', 'total_branca')
        .field('SUM(escola.qt_mat_bas_preta)', 'total_preta')
        .field('SUM(escola.qt_mat_bas_parda)', 'total_parda')
        .field('SUM(escola.qt_mat_bas_amarela)', 'total_amarela')
        .field('SUM(escola.qt_mat_bas_indigena)', 'total_indigena')
        .field('escola.ano_censo', 'year')
        .group('escola.ano_censo')
        .order('escola.ano_censo')
        .where('escola.localizacao_diferenciada_par is not null')
    }
    else if (req.query.dims && req.query.dims.includes('education_level_mod_agg')) {
        req.sql.from('escola')
        .field('SUM(escola.qt_mat_inf_cre)', 'total_cre')
        .field('SUM(escola.qt_mat_inf_pre)', 'total_pre')
        .field('SUM(escola.qt_mat_fund_ai)', 'total_fund_ai')
        .field('SUM(escola.qt_mat_fund_af)', 'total_fund_af')
        .field('SUM(escola.qt_mat_med_agg)', 'total_med')
        .field('SUM(escola.qt_mat_med_ct + escola.qt_mat_med_nm)', 'total_med_in')
        .field('SUM(escola.qt_mat_eja_fund_agg)', 'total_eja_fund')
        .field('SUM(escola.qt_mat_eja_med_agg)', 'total_eja_med')
        .field('SUM(escola.qt_mat_eja_fund_fic + escola.qt_mat_eja_med_fic + escola.qt_mat_eja_med_tec)', 'total_tec')
        .field('SUM(escola.qt_mat_prof_agg)', 'total_prof')
        .field('SUM(escola.qt_mat_bas)', 'total_total')
        .field('escola.ano_censo', 'year')
        .group('escola.ano_censo')
        .order('escola.ano_censo')
        .where('escola.localizacao_diferenciada_par is not null');

    }
    else if (req.query.dims && req.query.dims.includes('integral_time_agg')) {
        req.sql.from('turma,escola')
        .field('SUM(CASE WHEN turma.tempo_integral=0 then turma.num_matricula ELSE 0 END)', 'total_int_nao')
        .field('SUM(CASE WHEN turma.tempo_integral=1 then turma.num_matricula ELSE 0 END)', 'total_int')
        .field('SUM(CASE WHEN turma.tempo_integral=2 then turma.num_matricula ELSE 0 END)', 'total_int_nao_aplica')
        .field('escola.ano_censo', 'year')
        .group('escola.ano_censo')
        .order('escola.ano_censo')
        .where('turma.tipo_atendimento_id <= 2 and turma.escola_id = escola.id and turma.ano_censo = escola.ano_censo and escola.localizacao_diferenciada_par is not null');
    }
    else if (req.query.dims && req.query.dims.includes('period_agg')) {
        req.sql.from('turma,escola')
        .field('SUM(CASE WHEN turma.turma_turno_id=1 then turma.num_matricula ELSE 0 END)', 'total_qt_mat_bas_matutino')
        .field('SUM(CASE WHEN turma.turma_turno_id=2 then turma.num_matricula ELSE 0 END)', 'total_qt_mat_bas_vespertino')
        .field('SUM(CASE WHEN turma.turma_turno_id=3 then turma.num_matricula ELSE 0 END)', 'total_qt_mat_bas_noturno')
        .field('SUM(CASE WHEN turma.turma_turno_id=4 then turma.num_matricula ELSE 0 END)', 'total_qt_mat_bas_integral')
        .field('SUM(CASE WHEN turma.turma_turno_id=99 then turma.num_matricula ELSE 0 END)', 'total_qt_mat_bas_semi_ead')
        .field('escola.ano_censo', 'year')
        .group('escola.ano_censo')
        .order('escola.ano_censo')
        .where('turma.tipo_atendimento_id <= 2 and turma.escola_id = escola.id and turma.ano_censo = escola.ano_censo and escola.localizacao_diferenciada_par is not null');
    }
    else if (req.query.dims && req.query.dims.includes('modality_integral_time')) {
        req.sql.from('escola')
        .field('SUM(escola.qt_mat_inf_cre_int)', 'total_qt_mat_inf_cre_int')
        .field('SUM(escola.qt_mat_inf_pre_int)', 'total_qt_mat_inf_pre_int')
        .field('SUM(escola.qt_mat_fund_ai_int)', 'total_qt_mat_fund_ai_int')
        .field('SUM(escola.qt_mat_fund_af_int)', 'total_qt_mat_fund_af_int')
        .field('SUM(escola.qt_mat_med_int)', 'total_qt_mat_med_int')
        .field('escola.ano_censo', 'year')
        .group('escola.ano_censo')
        .order('escola.ano_censo')
        .where('escola.localizacao_diferenciada_par is not null');
    }
    else if (req.query.dims && req.query.dims.includes('special_education')) {
        req.sql.from('escola')
        .field('SUM(escola.qt_mat_esp_cc)', 'total_qt_mat_esp_cc')
        .field('SUM(escola.qt_mat_esp_ce)', 'total_qt_mat_esp_ce')
        .field('escola.ano_censo', 'year')
        .group('escola.ano_censo')
        .order('escola.ano_censo')
        .where('escola.localizacao_diferenciada_par is not null');
    }
    else {
        req.sql.from('escola')
        .field('SUM(escola.qt_mat_bas)', 'total')
        .field('escola.ano_censo', 'year')
        .group('escola.ano_censo')
        .order('escola.ano_censo')
        .where('escola.localizacao_diferenciada_par is not null');
    }
    next();
}, query, aggregateData, id2str.transform(false), response('enrollment_aggregate'));

module.exports = enrollmentAggregateApp;
