/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const enrollmentProjectionApp = express.Router();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const id2str = require(`${libs}/middlewares/id2str`);

const config = require(`${libs}/config`);

let rqf = new ReqQueryFields();

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValueToField({
    name: 'state',
    table: 'estado',
    tableField: ['nome', 'id'],
    resultField: ['state_name', 'state_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'estado_id',
        foreignTable: 'projecao_matricula_por_dependencia'
    }
}, 'dims').addValueToField({
    name: 'state',
    table: 'estado',
    tableField: 'nome',
    resultField: 'state_name',
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'estado_id',
        foreignTable: 'projecao_matricula_por_dependencia'
    }
}, 'filter').addValueToField({
    name: 'city',
    table: 'municipio',
    tableField: ['nome', 'id'],
    resultField: ['city_name', 'city_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'municipio_id',
        foreignTable: 'projecao_matricula_por_dependencia'
    }
}, 'dims').addValueToField({
    name: 'city',
    table: 'municipio',
    tableField: 'nome',
    resultField: 'city_name',
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'municipio_id',
        foreignTable: 'projecao_matricula_por_dependencia'
    }
}, 'filter').addValue({
    name: 'min_year',
    table: 'projecao_matricula_por_dependencia',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '>=',
        type: 'integer',
        field: 'ano_censo'
    }
}).addValue({
    name: 'max_year',
    table: 'projecao_matricula_por_dependencia',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '<=',
        type: 'integer',
        field: 'ano_censo'
    }
}).addValue({
    name: 'adm_dependency',
    table: 'projecao_matricula_por_dependencia',
    tableField: 'dependencia_adm_id',
    resultField: 'adm_dependency_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'dependencia_adm_id'
    }
});

enrollmentProjectionApp.get('/', rqf.parse(), rqf.build(), (req, res, next) => {
    req.sql.field("'Brasil'", 'name')
        .field('SUM(projecao_matricula_por_dependencia.urbano_dia_total)', 'urban_day_total')
        .field('SUM(projecao_matricula_por_dependencia.urbano_noite_total)', 'urban_night_total')
        .field('SUM(projecao_matricula_por_dependencia.rural_dia_total)', 'rural_day_total')
        .field('SUM(projecao_matricula_por_dependencia.rural_noite_total)', 'rural_night_total')
        .field('projecao_matricula_por_dependencia.etapa_ensino_escola_ano_id', 'education_level_school_year_id')
        .field('projecao_matricula_por_dependencia.ano_censo', 'year')
        .from('projecao_matricula_por_dependencia')
        .where('projecao_matricula_por_dependencia.etapa_ensino_escola_ano_id <> 7 AND projecao_matricula_por_dependencia.etapa_ensino_escola_ano_id < 71')
        .group('projecao_matricula_por_dependencia.etapa_ensino_escola_ano_id')
        .group('projecao_matricula_por_dependencia.ano_censo')
        .order('projecao_matricula_por_dependencia.ano_censo')
        .order('projecao_matricula_por_dependencia.etapa_ensino_escola_ano_id');

    next();
}, query, id2str.transform(), (req, res, next) => {

    let result = [];
    let i = 0;
    let j = 1;
    let base_year = req.result[0].year;

    let hashSet = new Set();
    let atual_city_name;
    let atual_city_id;
    let atual_state_name;
    let atual_state_id;
    while (i < req.result.length || j <= 63) {      // Adciona séries não existentes no banco com 0 nos totais.
        let atual = req.result[i];
        if (j > 63) {       // Caso j passou da última série existente, mudamos de dimensão.
            j = 1;

            if (base_year !== atual.year) {
                base_year = atual.year;
                hashSet = new Set();
            }
        }
        if (id2str.educationLevelSchoolYear(j) === id2str.educationLevelSchoolYear(99) || j === 7) {
            j++;
            continue;
        }

        if (j == 1) {
            let hash = ""
            if ('state' in req.dims)
                hash += atual.state_id;
            if ('city' in req.dims)
                hash += atual.city_id;

            if (!hashSet.has(hash)) {
                hashSet.add(hash);
                atual_city_id = atual.city_id;
                atual_city_name = atual.city_name;
                atual_state_id = atual.state_id;
                atual_state_name = atual.state_name;
            }
        }

        if (atual !== undefined && atual.education_level_school_year_id === j) {   // Série existe.
            atual.urban_day_total = parseInt(atual.urban_day_total, 10);
            atual.urban_night_total = ((atual.education_level_school_year_id >= 3 && atual.education_level_school_year_id < 10) || (atual.education_level_school_year_id >= 30)) ? parseInt(atual.urban_night_total, 10) : 0;   //Não conta matrículas noturnas da pré-escola e da creche
            atual.rural_day_total = parseInt(atual.rural_day_total, 10);
            atual.rural_night_total = ((atual.education_level_school_year_id >= 3 && atual.education_level_school_year_id < 10) || (atual.education_level_school_year_id >= 30)) ? parseInt(atual.rural_night_total, 10) : 0;
            result.push(atual);

            i++;
        }
        else {      //  Série não existe, adcionamos 0 ao resultado.
            let base_result = {
                name: req.result[0].name,
                urban_day_total: 0,
                urban_night_total: 0,
                rural_day_total: 0,
                rural_night_total: 0,
                education_level_school_year_id: j,
                year: base_year,
                education_level_school_year_name: id2str.educationLevelSchoolYear(j)
            };

            if ('city' in req.dims) {           // adciona os campos de cidade e/ou estado
                base_result.city_id = atual_city_id;
                base_result.city_name = atual_city_name;
            }
            if ('state' in req.dims) {
                base_result.state_id = atual_state_id;
                base_result.state_name = atual_state_name;
            }

            result.push(base_result)
        }
        j++;
    }

    req.result = result;
    next();
}, response('enrollment_projection'));

module.exports = enrollmentProjectionApp;
