const express = require('express');
const oauth2orize = require('oauth2orize');
const passport = require('passport');
const ClientPasswordStrategy = require('passport-oauth2-client-password');
const testApp = express();
const libs = `${process.cwd()}/libs`;

const Client = require(`${libs}/models/client`);
const User = require(`${libs}/models/user`)
var server = oauth2orize.createServer();

passport.use(new ClientPasswordStrategy(
    function(client_id, client_secret, done) {
      Client.findOne({where: {client_id: client_id} 
      }).then(function(err, client) {
        if(err){
            console.log("Erro de requisicao");
            return done(err);
        }
        if(!client){
            console.log("Erro de cliente");
            return done(null, false);
        }
        if (client.client_secret !== client_secret){
            console.log("Erro de geracao Chave Secreta");
            return done(null, false);
        } 
        console.log("Tudo certo nesse use");
        return done(null, client);
      })
    }
  ));

let generateTokens = (userId, clientId, done) => {
    // curries in `done` callback so we don't need to pass it
    let refreshTokenValue;
    let token;
    let tokenValue;

    RefreshToken.destroy({where:{"user_id": userId, "client_id": clientId}});
    AccessToken.destroy({where:{"user_id": userId, "client_id": clientId}});

    tokenValue = crypto.randomBytes(32).toString('hex');
    refreshTokenValue = crypto.randomBytes(32).toString('hex');

    AccessToken.create({
        user_id:userId, 
        client_id:clientId,
        token:tokenValue
    })

    let refreshed_token = refreshTokenValue;

    RefreshToken.create({
        user_id:userId, 
        client_id:clientId,
        token:refreshed_token
    })

    token.save((err) => {
        if (err) {
            log.error(err);
            return done(err);
        }
        done(null, tokenValue, refreshTokenValue, {
            'expires_in': config.security.tokenLife
        });
    })
};


let entrar = function(client, username, done) {
    User.findOne({ 
      where: {email:username} 
    }).then(function(user) {
      console.log(user)
      if(user == null){
        return done(null, false);
      }
      if(user.dataValues.origin != client.client_secret){
        console.log("Erro de client_secret");
        return done(null, false);
      }
      log.info(`Gerando token para usuário ${user.name}`);
      generateTokens(user._id, client._id, done);
    }).catch(function(error) {
      return done(error);
    });
  };





testApp.post('/', (req, res, next) =>{
    entrar(req.body, req.body.username);
});


module.exports = testApp;