/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/


const libs = `${process.cwd()}/libs`;

const conn = require(`${libs}/db/monet`);

const express = require('express');

const educationalBudget = express.Router();

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const id2str = require(`${libs}/middlewares/id2str`);

const addMissing = require(`${libs}/middlewares/addMissing`);

const config = require(`${libs}/config`);

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

let rqf = new ReqQueryFields();

let rqfId = new ReqQueryFields();

const db = require(`${libs}/db/query_exec`);

const log = require(`${libs}/log`)(module);

rqfId.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'federative_entity',
    table: 'orcamento_educacional',
    tableField: 'entidade_federativa',
    resultField: 'entidade_federativa_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'entidade_federativa'
    }
});

//Insert route in orcamento_educacional table
educationalBudget.post('/insert', (req, res, next) => {
    let id = req.body.id || null;
    let entidade_federativa = req.body.entidade_federativa || null;
    let csv = req.body.csv || null;

    //csv example
    //"RO|7777777|jiarana|8043|41768845|43141895|66081767|8216|24312922|158,2%"

     req.id = id;
     req.entidade_federativa = entidade_federativa;
     req.csv = csv.toString();
     req.date = new Date();

     //split o csv para adicionar separadamente nas colunas
    csv = csv.split("|");
    req.uf = csv[0];
    req.municipio_id = csv[1];
    req.nome = csv[2];
    req.matriculas = csv[3];
    req.receitas_vinculadas = csv[4];
    req.despesas_realizadas = csv[5];
    req.despesas_correntes = csv[6];
    req.valor_aluno = csv[7];
    req.completacao = csv[8];
    req.completacao_porcentagem = csv[9];

    let sqlQueryParams = [];

    //remove id duplicate
    let deleteQuery = squel.delete()
        .from("orcamento_educacional")
        .where('id = ' + req.id)
        .toString()

    //Exec delete sql
    log.debug(`Executing SQL query '${deleteQuery}' with params '${[sqlQueryParams]}'`);
    return new Promise((resolve, reject) => {
        // Prepare statement
        conn.prepare(deleteQuery, true).then((dbQuery) => {
            // Execute query
            dbQuery.exec(sqlQueryParams).then((dbResult) => {
                // release resources allocated for the prepared statement
                dbQuery.release();
                resolve(dbResult.data);
                req.result = "Insertion Success"
                next();
            }).catch((queryError) => {
                log.error(`SQL query execution error: ${queryError.message}`);
                req.result = "SQL query execution error:" + queryError.message;
                log.error(`SQL query: ${deleteQuery} with params: ${sqlQueryParams}`);
                // release resources allocated for the prepared statement
                dbQuery.release();
                next();
            });
        }).catch((prepError) => {
            log.error(`SQL prepared statement error: ${prepError.message}`);
            req.result = "SQL query execution error:" + queryError.message;
            log.error(`SQL query: ${deleteQuery} with params: ${sqlQueryParams}`);
            next();
        });
    });

}, (req, res, next) => {
    //build query
    let insertQuery = squel.insert()
        .into("orcamento_educacional")
        .set("id", req.id)
        .set("entidade_federativa", req.entidade_federativa)
        .set("csv", req.csv)
        .set("data", req.date.toString())
        .set("uf", req.uf)
        .set("municipio_id", req.municipio_id)
        .set("nome", req.nome)
        .set("receitas_vinculadas", req.receitas_vinculadas)
        .set("despesas_realizadas", req.despesas_realizadas)
        .set("despesas_correntes", req.despesas_correntes)
        .set("valor_aluno", req.valor_aluno)
        .set("completacao", req.completacao)
        .set("completacao_porcentagem", req.completacao_porcentagem)
        .toString()

    let sqlQueryParams = [];

    //Exec insert sql
    log.debug(`Executing SQL query '${insertQuery}' with params '${[sqlQueryParams]}'`);
    return new Promise((resolve, reject) => {
        // Prepare statement
        conn.prepare(insertQuery, true).then((dbQuery) => {
            // Execute query
            dbQuery.exec(sqlQueryParams).then((dbResult) => {
                // release resources allocated for the prepared statement
                dbQuery.release();
                resolve(dbResult.data);
                req.result = "Insertion Success"
                next();
            }).catch((queryError) => {
                log.error(`SQL query execution error: ${queryError.message}`);
                req.result = "SQL query execution error:" + queryError.message;
                log.error(`SQL query: ${insertQuery} with params: ${sqlQueryParams}`);
                // release resources allocated for the prepared statement
                dbQuery.release();
                next();
            });
        }).catch((prepError) => {
            log.error(`SQL prepared statement error: ${prepError.message}`);
            req.result = "SQL query execution error:" + queryError.message;
            log.error(`SQL query: ${insertQuery} with params: ${sqlQueryParams}`);
            next();
        });
    });

    next();
}, response('educationalBudget'));

//Delete orcamento_educacional table
educationalBudget.get('/delete', (req, res, next) => {

    //build query
    let insertQuery = squel.delete()
        .from("orcamento_educacional")
        .toString()

    let sqlQueryParams = [];

    //Exec sql in monet
    log.debug(`Executing SQL query '${insertQuery}' with params '${[sqlQueryParams]}'`);
    return new Promise((resolve, reject) => {
        // Prepare statement
        conn.prepare(insertQuery, true).then((dbQuery) => {
            // Execute query
            dbQuery.exec(sqlQueryParams).then((dbResult) => {
                // release resources allocated for the prepared statement
                dbQuery.release();
                resolve(dbResult.data);
                req.result = "Delete Table Success"
                next();
            }).catch((queryError) => {
                log.error(`SQL query execution error: ${queryError.message}`);
                req.result = "SQL query execution error:" + queryError.message;
                log.error(`SQL query: ${insertQuery} with params: ${sqlQueryParams}`);
                // release resources allocated for the prepared statement
                dbQuery.release();
                next();
            });
        }).catch((prepError) => {
            log.error(`SQL prepared statement error: ${prepError.message}`);
            req.result = "SQL query execution error:" + queryError.message;
            log.error(`SQL query: ${insertQuery} with params: ${sqlQueryParams}`);
            next();
        });
    });

    next();
}, response('educationalBudget'));

//Return all id's in table
educationalBudget.get('/id', rqfId.parse(), rqfId.build(), (req, res, next) => {
        req.sql.from('orcamento_educacional')
        .field('orcamento_educacional.municipio_id')
        next();
}, query, response('educationalBudget'));

//Return count id grouop by entidade_federativa
educationalBudget.get('/finish', rqf.parse(), (req, res, next) => {
        req.sql.field('COUNT(*)', 'total')
        .field('orcamento_educacional.entidade_federativa', 'entidade_federativa')
        .from('orcamento_educacional')
        .group('orcamento_educacional.entidade_federativa')
        .order('orcamento_educacional.entidade_federativa')
        next();
}, query, response('educationalBudget'));

//return all data
educationalBudget.get('/', rqf.parse(), (req, res, next) => {
        req.sql.from('orcamento_educacional')
        .field('orcamento_educacional.id')
        .field('orcamento_educacional.entidade_federativa', 'entidade_federativa')
        .field('orcamento_educacional.data', 'data_insercao')
        .field('orcamento_educacional.uf', 'uf')
        .field('orcamento_educacional.municipio_id', 'municipio_id')
        .field('orcamento_educacional.nome', 'nome')
        .field('orcamento_educacional.receitas_vinculadas', 'receitas_vinculadas')
        .field('orcamento_educacional.despesas_realizadas', 'despesas_realizadas')
        .field('orcamento_educacional.despesas_correntes', 'despesas_correntes')
        .field('orcamento_educacional.valor_aluno', 'valor_aluno')
        .field('orcamento_educacional.completacao', 'completacao')
        .field('orcamento_educacional.completacao_porcentagem', 'completacao_porcentagem')
        .field('orcamento_educacional.csv', 'csv')
        next();
}, query, response('educationalBudget'));

//Insert route in orcamento_educacional table
educationalBudget.post('/insert_pqr', (req, res, next) => {
    let id = JSON.parse(req.body.id) || null;
    let pqr = JSON.parse(req.body.pqr) || null;

     req.id = id;
     req.pqr = pqr;
     req.date = new Date();

    //build query
    let insertQuery = squel.insert()
        .into("orcamento_educacional_pqr")
        .set("id", req.id.toString())
        .set("pqr", req.pqr.toString())
        .set("data", req.date.toString())
        .toString()

    let sqlQueryParams = [];

    //Exec sql
    log.debug(`Executing SQL query '${insertQuery}' with params '${[sqlQueryParams]}'`);
    return new Promise((resolve, reject) => {
        // Prepare statement
        conn.prepare(insertQuery, true).then((dbQuery) => {
            // Execute query
            dbQuery.exec(sqlQueryParams).then((dbResult) => {
                // release resources allocated for the prepared statement
                dbQuery.release();
                resolve(dbResult.data);
                req.result = "Insertion Success"
                next();
            }).catch((queryError) => {
                log.error(`SQL query execution error: ${queryError.message}`);
                req.result = "SQL query execution error:" + queryError.message;
                log.error(`SQL query: ${insertQuery} with params: ${sqlQueryParams}`);
                // release resources allocated for the prepared statement
                dbQuery.release();
                next();
            });
        }).catch((prepError) => {
            log.error(`SQL prepared statement error: ${prepError.message}`);
            req.result = "SQL query execution error:" + queryError.message;
            log.error(`SQL query: ${insertQuery} with params: ${sqlQueryParams}`);
            next();
        });
    });

    next();
}, response('educationalBudget'));

educationalBudget.get('/get_pqr', (req, res, next) => {
    req.sql.from('orcamento_educacional_pqr')
    .field('orcamento_educacional_pqr.id', 'id')
    .field('orcamento_educacional_pqr.pqr', 'pqr')
    .field('orcamento_educacional_pqr.data', 'data')
    next();
}, query, response('educationalBudget'));

module.exports = educationalBudget;

