/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const idhmlApp = express.Router();

const libs = `${process.cwd()}/libs`;

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const id2str = require(`${libs}/middlewares/id2str`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const addMissing = require(`${libs}/middlewares/addMissing`);

const config = require(`${libs}/config`); 

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

let rqf = new ReqQueryFields();

idhmlApp.use(cache('15 day'));

idhmlApp.get('/year_range', (req, res, next) => {
    req.sql.from('adh_idh')
    .field('MIN(adh_idh.ano_censo)', 'start_year')
    .field('MAX(adh_idh.ano_censo)', 'end_year');
    next();
}, query, (req, res, next) => {
    req.sql.from('adh_idh_uf')
    .field('MIN(adh_idh_uf.ano_censo)', 'start_year')
    .field('MAX(adh_idh_uf.ano_censo)', 'end_year');
    req.old_result = req.result;
    next();
}, query, (req, res, next) => {
    if (req.old_result[0].start_year < req.result[0].start_year) {
        req.result[0].start_year = req.old_result[0].start_year;
    }
    if (req.old_result[0].end_year > req.result[0].end_year) {
        req.result[0].end_year = req.old_result[0].old_result;
    }
    next();
}, query, response('range'));

idhmlApp.get('/years', (req, res, next) => {
    req.sql.from('adh_idh')
    .field('DISTINCT adh_idh.ano_censo', 'year');
    next();
}, query, (req, res, next) => {
    req.oldResult = req.result;

    req.sql = squel.select();

    req.sql.from('adh_idh_uf')
    .field('DISTINCT adh_idh_uf.ano_censo', 'year');
    next();
}, query, (req, res, next) => {
    let result = Object.assign(req.oldResult, req.result);
    req.result = result;
    next();
}, response('years'));

idhmlApp.get('/source', (req, res, next) => {
    req.sql.from('fonte')
    .field('fonte', 'source')
    .where('tabela = \'adh_idh\'');
    next();
}, query, response('source'));

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'city',
    table: 'municipio',
    tableField: ['nome', 'id'],
    resultField: ['city_name', 'city_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'municipio_id',
        table: 'adh_idh'
    },
    join: {
        primary: 'id',
        foreign: 'municipio_id',
        foreignTable: 'adh_idh'
    }
}).addValue({
    name: 'min_year',
    table: '@',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '>=',
        type: 'integer',
        table: '@',
        field: 'ano_censo'
    }
}).addValue({
    name: 'max_year',
    table: '@',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '<=',
        type: 'integer',
        table: '@',
        field: 'ano_censo'
    }
}).addValue({
    name: 'state',
    table: 'estado',
    tableField: ['nome', 'id'],
    resultField: ['state_name', 'state_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'estado_id',
        table: '@'
    },
    join: {
        primary: 'id',
        foreign: 'estado_id',
        foreignTable: '@'
    }
});

idhmlApp.get('/', rqf.parse(), (req, res, next) => {

    if (("city" in req.dims) || ("city" in req.filter)) {
        req.sql.from('adh_idh')
        .field('adh_idh.idhm_l', 'total')
        .field('adh_idh.ano_censo', 'year')
        .field('adh_idh.municipio_id', 'city_id')
        .group('adh_idh.idhm_l')
        .group('adh_idh.ano_censo')
        .group('adh_idh.municipio_id');
    } else if (("state" in req.filter) || ("state" in req.dims)) {
        req.sql.from('adh_idh_uf')
        .field('adh_idh_uf.idhm_l', 'total')
        .field('adh_idh_uf.ano_censo', 'year')
        .field('adh_idh_uf.estado_id', 'state_id')
        .group('adh_idh_uf.idhm_l')
        .group('adh_idh_uf.ano_censo')
        .group('adh_idh_uf.estado_id');
    } else {
        res.status(400);
        next({
            status: 400,
            message: 'Wrong/No filter specified'
        });
    }
    next();
}, rqf.build(), query, addMissing(rqf), id2str.transform(), response('idhme'));

module.exports = idhmlApp;
