const express = require('express');

const resetTokenApp = express.Router();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const ResetToken = require(`${libs}/models/resetToken`);

const User = require(`${libs}/models/user`);

resetTokenApp.get('/:token', (req, res, next) => {
    let token = req.params.token;
    ResetToken.findOne({token: token}, (err, rToken) => {
        if(err) {
            log.error(err);
            return next(err);
        }
        if(!rToken) {
            // TODO: generate new reset token
            res.statusCode = 404;
            return next({msg: 'Token not found', status:404});
        }
        if (rToken.hasExpired()) {
            res.statusCode = 410;
            ResetToken.remove({token: token}, (err) => {
                if(err) {
                    log.error(err);
                    next(err);
                }
            })
            return next({msg: 'Token expired', status: 410});
        }
        User.findByPk(rToken.userId, (err, user) => {
            if(err) {
                log.error(err);
                next(err);
            }
            let u = user.toObject();
            delete u.salt;
            delete u.hashedPassword;
            res.json({user: u});
        });
    });
});
resetTokenApp.post('/:token', (req, res, next) => {
    let token = req.params.token;
    ResetToken.findOne({token: token}, (err, rToken) => {
        if(err) {
            log.error(err);
            return next(err);
        }
        if(!rToken) {
            res.statusCode = 404;
            return next({msg: 'Token not found', status:404});
        }
        User.findByPk(rToken.userId, (err, user) => {
            if(err) {
                log.error(err);
                next(err);
            }
            user.password = req.body.password;
            user.save((err) => {
                if(err) {
                    log.error(err);
                    next(err);
                }
                ResetToken.remove({token: token}, (err) => {
                    if(err) {
                        log.error(err);
                        next(err);
                    }
                })
                res.json({msg: "Senha alterada com sucesso"});
            })
        });
    });
})

module.exports = resetTokenApp;
