const express = require('express');

const verifyTokenApp = express.Router();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const VerificationToken = require(`${libs}/models/verificationToken`);

const User = require(`${libs}/models/user`);

verifyTokenApp.get('/:token', (req, res, next) => {
    let token = req.params.token;
    VerificationToken.findOne({token: token}, (err, vToken) => {
        if(err) {
            log.error(err);
            return next(err);
        }
        if(!vToken) {
            // TODO: generate new verification token
            res.statusCode = 404;
            return next({msg: 'Token not found', status:404});
        }
        User.findOne({id:vToken.userId}, (err, user) => {
            if(err) {
                log.error(err);
                next(err);
            }
            user.verified = true;
            user.save((err) => {
                if(err) {
                    log.error(err);
                    next(err);
                }
            });
            let u = user.toObject();
            delete u.salt;
            delete u.hashedPassword;
            vToken.verified = true;
            vToken.save((err) => {
                if(err) {
                    log.error(err);
                    next(err);
                }
            });
            res.json({msg: 'User verified', user: u});
        });
    });
});

module.exports = verifyTokenApp;
