const express = require('express');

const activityApp = express();

const libs = `${process.cwd()}/libs`;

const config = require(`${libs}/config`);

const log = require(`${libs}/log`)(module);

const Activity = require(`${libs}/models/activity`);

const response = require(`${libs}/middlewares/response`);

const email = require(`${libs}/middlewares/email`);

const passport = require('passport');

const fileWorker = require('./file.controller.js');

let upload = require('../middlewares/multer.config.js');

const authorized = require(`${libs}/middlewares/authorize.js`);

function emailSyntax(email) {
  const regex = /^(([^<>()\[\]\.,;:\s@\"]+(\.[^<>()\[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i;
  return regex.test(email);
}

activityApp.get('/', async (req, res, next) => {
  const ordenar = req.query.order || 'DESC';
  const filter = req.query.filter || 'all';
  const page = parseInt(req.query.page) || 1; // Current page number
  const pageSize = parseInt(req.query.pageSize) || 5; // Number of items per page
  if (filter === 'all') {
    const totalCount = await Activity.count();
    const offset = (page - 1) * pageSize;

    const acts = await Activity.findAll({
      offset,
      limit: pageSize,
      order: [
        ['date', ordenar],
      ],
    });

    res.json({
      page,
      pageSize,
      totalCount,
      data: acts,
    });
  }
  else {
    const totalCount = await Activity.count({ where: { is_draft: filter } });
    const offset = (page - 1) * pageSize;

    const acts = await Activity.findAll({
      offset,
      limit: pageSize,
      order: [
        ['date', ordenar],
      ],
      where: {
        is_draft: filter
      }
    });

    res.json({
      page,
      pageSize,
      totalCount,
      data: acts,
    });
  }
});

activityApp.get('/drafts', async (req, res, next) => {
  const page = parseInt(req.query.page) || 1;
  const pageSize = parseInt(req.query.pageSize) || 5;
  try {
    const totalCount = await Activity.count({
      where: {
        is_draft: true
      }
    });
    const offset = (page - 1) * pageSize;

    const acts = await Activity.findAll({
      offset,
      limit: pageSize,
      where: {
        is_draft: true
      },
      order: [
        ['date', 'DESC']]
    });

    res.json({
      page,
      pageSize,
      totalCount,
      data: acts,
    });
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: 'An error occurred' });
  }
});

activityApp.get('/:id', (req, res, next) => {
  Activity.findByPk(req.params.id).then((act) => {
    if (!act) {
      res.statusCode = 404;
      res.json({ msg: "A atividade não está cadastrada" });
    } else {
      let actJSON = act.toJSON();
      //transform data yyyy-mm-dd to dd/mm/yyyy
      let date = actJSON.date.split('-');
      let date_start= actJSON.date_start.split('-');
      actJSON.date = date[2] + '/' + date[1] + '/' + date[0];
      actJSON.date_start = date_start[2] + '/' + date_start[1] + '/' + date_start[0];
      req.result = actJSON;
      next();
    }
  }).catch(function (err) {
    log.error(err);
    return next(err);
  });
}, response('activity'));


function transformDateFormat(dateString) {
  // Split the date string into day, month, and year components
  var parts = dateString.split('/');

  // Extract day, month, and year values
  var day = parts[0];
  var month = parts[1];
  var year = parts[2];

  // Concatenate the components in "yyyy/mm/dd" format
  var transformedDate = year + '/' + month + '/' + day;

  return transformedDate;
}



activityApp.post('/', passport.authenticate('bearer', { session: false }), authorized('criar atividade'), async (req, res, next) => {
  console.log(req.body);
  let act = await Activity.create({
    id: 0,
    type: req.body.tipo,
    title: req.body.titulo,
    subtitle: req.body.subtitulo,
    date: transformDateFormat(req.body.dataDePostagem),
    authors: req.body.autor,
    text: req.body.texto,
    name_headline: req.body.nome,
    resume_headline: req.body.resumo,
    date_start: transformDateFormat(req.body.dataInicio),
    date_end: transformDateFormat(req.body.dataEnd),
    local_headline: req.body.local,
    additional_headline: req.body.informacoes,
    is_draft: req.body.rascunho,
    is_headline: req.body.is_headline
  }).catch(function (err) {
    log.error(err);
    let errors = [];
    for (let errName in err.errors) {
      errors.push(err.errors[errName].message);
    }
    log.error(errors);
    res.statusCode = 400;
    return res.json({ err, errors });
    // handle error;
  });
  if (!act) {
    res.statusCode = 400;
    return res;
  }
  req.result = act.toJSON();
  next();
}, response('activity'));

activityApp.put('/:id', passport.authenticate('bearer', { session: false }), authorized('editar atividade'), async (req, res, next) => {
  let act = await Activity.findByPk(req.params.id).catch(function (err) {
    if (err) {
      log.error(err);
      return next({ err });
    }
  })
  if (!act) {
    res.statusCode = 404;
    return next({
      err: {
        message: 'Atividade não encontrada'
      }
    });
  }
  console.log("TEste");
  act.type = req.body.tipo || act.type;
  act.title = req.body.titulo || act.title;
  act.subtitle = req.body.subtitulo || act.subtitle;
  act.date = req.body.dataDePostagem || act.date;
  act.authors = req.body.autor || act.authors;
  act.text = req.body.texto || act.text;
  act.name_headline = req.body.nome || act.name_headline;
  act.resume_headline = req.body.resumo || act.resume_headline;
  act.date_start = req.body.dataStart || act.date_start;
  act.date_end = req.body.dataEnd || act.date_end;
  act.local_headline = req.body.local || act.local_headline;
  act.additional_headline = req.body.informacoes || act.additional_headline;
  act.is_draft = req.body.rascunho || act.is_draft;
  //act.is_headline = req.body.is_headline || act.is_headline;

  act.save().catch(err => {
    if (err) {
      log.error(err);
      return next({ message: 'Erro ao atualizar publicacao' });
    }
  })
  let activity = act.toJSON();
  res.json({ activity: activity });

});

activityApp.delete('/:id', passport.authenticate('bearer', { session: false }), authorized('editar atividade'), async (req, res, next) => {
  await Activity.destroy({ where: { id: req.params.id } }).catch(function (err) {
    if (err) {
      log.error(err);
      return next({ err });
    }
  });
  return next({ msg: 'Activity Deleted', status: 200 });
});

module.exports = activityApp;
