/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/


const express = require('express');

const api = express();

const libs = `${process.cwd()}/libs`;

const config = require(`${libs}/config`);

const test = require('./test');

const classes = require('./class');

const enrollment = require('./enrollment');

const state = require('./state');

const region = require('./region');

const city = require('./city');

const school = require('./school');

const simulation = require('./simulation');

const user = require('./user');

const classroom = require('./classroom');

const teacher = require('./teacher');

const idhme = require('./idhme');

const pibpercapita = require('./pibpercapita')

const population = require('./population')

const rateSchool = require('./rateSchool')

const glossEnrollmentRatio = require('./glossEnrollmentRatio')

const liquidEnrollmentRatio = require('./liquidEnrollmentRatio')

const idhm = require('./idhm');

const idhmr = require('./idhmr');

const idhml = require('./idhml');

const oauth2 = require(`${libs}/middlewares/oauth2`);

const verifyToken = require(`${libs}/routes_v1/verifyToken`);

const resetToken = require(`${libs}/routes_v1/resetToken`);

const educationYears = require(`${libs}/routes_v1/educationYears`);

const downloads = require(`${libs}/routes_v1/downloads`);

const infrastructure = require(`${libs}/routes_v1/infrastructure`);

const schoolInfrastructure = require(`${libs}/routes_v1/schoolInfrastructure`);

const distributionFactor = require(`${libs}/routes_v1/distributionFactor`);

const siope = require(`${libs}/routes_v1/siope`);

const verifyTeacher = require(`${libs}/routes_v1/portalMec`);

const outOfSchool = require(`${libs}/routes_v1/outOfSchool`);

const classroomCount = require(`${libs}/routes_v1/classroomCount`);

const transport = require(`./transport`);

const auxiliar = require(`${libs}/routes_v1/auxiliar`);

const dailyChargeAmount = require(`${libs}/routes_v1/dailyChargeAmount`);

const cub = require(`${libs}/routes_v1/cub`);

const classCount = require(`${libs}/routes_v1/classCount`);

const portalMecInep = require(`${libs}/routes_v1/portalMecInep`);

const enrollmentProjection = require(`${libs}/routes_v1/enrollmentProjection`);

const employees = require(`${libs}/routes_v1/employees`);

const financial = require(`${libs}/routes_v1/financial`);

const universityEnrollment = require(`${libs}/routes_v1/universityEnrollment`);

const courseCount = require(`${libs}/routes_v1/courseCount`);

const university = require(`${libs}/routes_v1/university`);

const universityTeacher = require(`${libs}/routes_v1/universityTeacher`);

const educationalBudget = require(`${libs}/routes_v1/educationalBudget`);

const schoolLocation = require(`${libs}/routes_v1/schoolLocation`);

const studentsAee = require(`${libs}/routes_v1/studentsAee`);

const mesoregion = require(`${libs}/routes_v1/mesoregion`);

const microregion = require(`${libs}/routes_v1/microregion`);

const location = require(`${libs}/routes_v1/location`);

const disciplines = require(`${libs}/routes_v1/disciplines`);

const universityLocalOffer = require(`${libs}/routes_v1/universityLocalOffer`);

const message = require(`${libs}/routes_v1/message`);

const courseStudents = require(`${libs}/routes_v1/courseStudents`);

const publication = require(`${libs}/routes_v1/publication`);

const activity = require(`${libs}/routes_v1/activity`);

const newPnad = require(`${libs}/routes_v1/newPnad`);

const rateSchoolNew = require(`${libs}/routes_v1/rateSchoolNew`)

const enrollmentAggregate = require(`${libs}/routes_v1/enrollmentAggregate`);

const employeesAggregate = require(`${libs}/routes_v1/employeesAggregate`);

const courseAggregate = require(`${libs}/routes_v1/courseAggregate`);

const federativeEntity = require(`${libs}/routes_v1/federativeEntity`);

const email = require(`${libs}/routes_v1/email`);

const uniLocalOfferAggregate = require(`${libs}/routes_v1/uniLocalOfferAggregate`)

const basicEducationConclusion = require(`${libs}/routes_v1/basicEducationConclusion`);

const adjustedLiquidFrequency = require(`${libs}/routes_v1/adjustedLiquidFrequency`);

api.get('/', (req, res) => {
    res.json({ msg: 'SimCAQ API v1 is running' });
});

// mount API routes_v1
api.use('/test', test);
api.use('/user', user);
api.use('/simulation', simulation);
api.use('/class', classes);
api.use('/enrollment', enrollment);
api.use('/state', state);
api.use('/region', region);
api.use('/city', city);
api.use('/school', school);
api.use('/classroom', classroom);
api.use('/teacher', teacher);
api.use('/idhmr', idhmr);
api.use('/idhm', idhm);
api.use('/idhme', idhme);
api.use('/pibpercapita', pibpercapita);
api.use('/population', population);
api.use('/rate_school', rateSchool);
api.use('/gloss_enrollment_ratio', glossEnrollmentRatio);
api.use('/liquid_enrollment_ratio', liquidEnrollmentRatio);
api.use('/idhml', idhml);
api.use('/auth/token', oauth2.token);
api.use('/verify', verifyToken);
api.use('/reset', resetToken);
api.use('/education_years', educationYears);
api.use('/downloads', downloads);
api.use('/infrastructure', infrastructure);
api.use('/school_infrastructure', schoolInfrastructure);
api.use('/distribution_factor', distributionFactor);
api.use('/siope', siope);
api.use('/out_of_school', outOfSchool);
api.use('/classroom_count', classroomCount);
api.use('/daily_charge_amount', dailyChargeAmount);
api.use('/transport', transport);
api.use('/cub', cub);
api.use('/auxiliar', auxiliar);
api.use('/verify_teacher', verifyTeacher);
api.use('/class_count', classCount);
api.use('/portal_mec_inep', portalMecInep);
api.use('/enrollment_projection', enrollmentProjection);
api.use('/employees', employees);
api.use('/financial', financial);
api.use('/university_enrollment', universityEnrollment);
api.use('/university', university);
api.use('/university_teacher', universityTeacher);
api.use('/course_count', courseCount);
api.use('/school_location', schoolLocation);
api.use('/students_aee', studentsAee);
api.use('/mesoregion', mesoregion);
api.use('/microregion', microregion);
api.use('/location', location);
api.use('/disciplines', disciplines);
api.use('/universityLocalOffer', universityLocalOffer);
api.use('/message', message);
api.use('/course_students', courseStudents);
api.use('/new_pnad', newPnad);
api.use('/rate_school_new', rateSchoolNew)
api.use('/enrollmentAggregate', enrollmentAggregate);
api.use('/employeesAggregate', employeesAggregate);
api.use('/course_aggregate', courseAggregate);
api.use('/federativeEntity', federativeEntity);
api.use('/uni_offer_aggregate', uniLocalOfferAggregate);
api.use('/basic_education_conclusion', basicEducationConclusion);
api.use('/adjusted_liquid_frequency', adjustedLiquidFrequency);

//Publication 
api.use('/publication', publication);

//Activity
api.use('/activity', activity);

//Email 
api.use('/email', email);

module.exports = api;
